/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQStompProtocolMessageBundle_impl
implements ActiveMQStompProtocolMessageBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQStompProtocolMessageBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public IllegalStateException negativeConnectionTTL(Long ttl) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339000: Stomp Connection TTL cannot be negative: {}", (Object[])new Object[]{ttl}).getMessage();
        IllegalStateException objReturn_negativeConnectionTTL = new IllegalStateException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_negativeConnectionTTL);
        return objReturn_negativeConnectionTTL;
    }

    @Override
    public ActiveMQStompException destinationNotExist(String destination) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339001: Destination does not exist: {}", (Object[])new Object[]{destination}).getMessage();
        ActiveMQStompException objReturn_destinationNotExist = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_destinationNotExist);
        return objReturn_destinationNotExist;
    }

    @Override
    public ActiveMQStompException versionNotSupported(String acceptVersion) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339002: Stomp versions not supported: {}", (Object[])new Object[]{acceptVersion}).getMessage();
        ActiveMQStompException objReturn_versionNotSupported = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_versionNotSupported);
        return objReturn_versionNotSupported;
    }

    @Override
    public ActiveMQStompException nullHostHeader() {
        String returnString = "AMQ339003: Header host is null";
        ActiveMQStompException objReturn_nullHostHeader = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_nullHostHeader);
        return objReturn_nullHostHeader;
    }

    @Override
    public String hostCannotBeNull() {
        String returnString = "AMQ339004: Cannot accept null as host";
        return returnString;
    }

    @Override
    public ActiveMQStompException hostNotMatch() {
        String returnString = "AMQ339005: Header host does not match server host";
        ActiveMQStompException objReturn_hostNotMatch = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_hostNotMatch);
        return objReturn_hostNotMatch;
    }

    @Override
    public String hostNotMatchDetails(String host) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339006: host {} does not match server host name", (Object[])new Object[]{host}).getMessage();
        return returnString;
    }

    @Override
    public ActiveMQStompException connectionDestroyed() {
        String returnString = "AMQ339007: Connection was destroyed.";
        ActiveMQStompException objReturn_connectionDestroyed = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_connectionDestroyed);
        return objReturn_connectionDestroyed;
    }

    @Override
    public ActiveMQStompException connectionNotEstablished() {
        String returnString = "AMQ339008: Connection has not been established.";
        ActiveMQStompException objReturn_connectionNotEstablished = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_connectionNotEstablished);
        return objReturn_connectionNotEstablished;
    }

    @Override
    public ActiveMQStompException errorGetSession(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339009: Exception getting session", (Object[])new Object[]{e}).getMessage();
        ActiveMQStompException objReturn_errorGetSession = new ActiveMQStompException(returnString);
        objReturn_errorGetSession.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorGetSession);
        return objReturn_errorGetSession;
    }

    @Override
    public ActiveMQStompException invalidConnection() {
        String returnString = "AMQ339010: Connection is not valid.";
        ActiveMQStompException objReturn_invalidConnection = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidConnection);
        return objReturn_invalidConnection;
    }

    @Override
    public ActiveMQStompException errorSendMessage(Message message, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339011: Error sending message {}", (Object[])new Object[]{message, e}).getMessage();
        ActiveMQStompException objReturn_errorSendMessage = new ActiveMQStompException(returnString);
        objReturn_errorSendMessage.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorSendMessage);
        return objReturn_errorSendMessage;
    }

    @Override
    public ActiveMQStompException errorBeginTx(String txID, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339012: Error beginning a transaction {}", (Object[])new Object[]{txID, e}).getMessage();
        ActiveMQStompException objReturn_errorBeginTx = new ActiveMQStompException(returnString);
        objReturn_errorBeginTx.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorBeginTx);
        return objReturn_errorBeginTx;
    }

    @Override
    public ActiveMQStompException errorCommitTx(String txID, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339013: Error committing {}", (Object[])new Object[]{txID, e}).getMessage();
        ActiveMQStompException objReturn_errorCommitTx = new ActiveMQStompException(returnString);
        objReturn_errorCommitTx.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorCommitTx);
        return objReturn_errorCommitTx;
    }

    @Override
    public ActiveMQStompException errorAbortTx(String txID, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339014: Error aborting {}", (Object[])new Object[]{txID, e}).getMessage();
        ActiveMQStompException objReturn_errorAbortTx = new ActiveMQStompException(returnString);
        objReturn_errorAbortTx.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorAbortTx);
        return objReturn_errorAbortTx;
    }

    @Override
    public ActiveMQStompException noDestination() {
        String returnString = "AMQ339015: Client must set destination or id header to a SUBSCRIBE command";
        ActiveMQStompException objReturn_noDestination = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_noDestination);
        return objReturn_noDestination;
    }

    @Override
    public ActiveMQStompException errorCreatingSubscription(String subscriptionID, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339016: Error creating subscription {}", (Object[])new Object[]{subscriptionID, e}).getMessage();
        ActiveMQStompException objReturn_errorCreatingSubscription = new ActiveMQStompException(returnString);
        objReturn_errorCreatingSubscription.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorCreatingSubscription);
        return objReturn_errorCreatingSubscription;
    }

    @Override
    public ActiveMQStompException errorUnsubscribing(String subscriptionID, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339017: Error unsubscribing {}", (Object[])new Object[]{subscriptionID, e}).getMessage();
        ActiveMQStompException objReturn_errorUnsubscribing = new ActiveMQStompException(returnString);
        objReturn_errorUnsubscribing.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorUnsubscribing);
        return objReturn_errorUnsubscribing;
    }

    @Override
    public ActiveMQStompException errorAck(String messageID, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339018: Error acknowledging message {}", (Object[])new Object[]{messageID, e}).getMessage();
        ActiveMQStompException objReturn_errorAck = new ActiveMQStompException(returnString);
        objReturn_errorAck.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorAck);
        return objReturn_errorAck;
    }

    @Override
    public ActiveMQStompException invalidTwoCRs() {
        String returnString = "AMQ339019: Invalid char sequence: two consecutive CRs.";
        ActiveMQStompException objReturn_invalidTwoCRs = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidTwoCRs);
        return objReturn_invalidTwoCRs;
    }

    @Override
    public ActiveMQStompException badCRs() {
        String returnString = "AMQ339020: Invalid char sequence: There is a CR not followed by an LF";
        ActiveMQStompException objReturn_badCRs = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_badCRs);
        return objReturn_badCRs;
    }

    @Override
    public ActiveMQStompException notValidNewLine(byte b) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339021: Expect new line char but is {}", (Object[])new Object[]{b}).getMessage();
        ActiveMQStompException objReturn_notValidNewLine = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_notValidNewLine);
        return objReturn_notValidNewLine;
    }

    @Override
    public String unexpectedNewLine(byte b) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339022: Expect new line char but is {}", (Object[])new Object[]{b}).getMessage();
        return returnString;
    }

    @Override
    public ActiveMQStompException invalidCommand(String dumpByteArray) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339023: Invalid STOMP frame: {}", (Object[])new Object[]{dumpByteArray}).getMessage();
        ActiveMQStompException objReturn_invalidCommand = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidCommand);
        return objReturn_invalidCommand;
    }

    @Override
    public String invalidFrame(String dumpByteArray) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339024: Invalid STOMP frame: {}", (Object[])new Object[]{dumpByteArray}).getMessage();
        return returnString;
    }

    @Override
    public ActiveMQStompException failToAckMissingID(String id) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339025: failed to ack because no message with id: {}", (Object[])new Object[]{id}).getMessage();
        ActiveMQStompException objReturn_failToAckMissingID = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_failToAckMissingID);
        return objReturn_failToAckMissingID;
    }

    @Override
    public ActiveMQStompException subscriptionIDMismatch(String subscriptionID, String actualID) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339026: subscription id {} does not match {}", (Object[])new Object[]{subscriptionID, actualID}).getMessage();
        ActiveMQStompException objReturn_subscriptionIDMismatch = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_subscriptionIDMismatch);
        return objReturn_subscriptionIDMismatch;
    }

    @Override
    public IllegalStateException missingClientID() {
        String returnString = "AMQ339027: Cannot create a subscriber on the durable subscription if the client-id of the connection is not set";
        IllegalStateException objReturn_missingClientID = new IllegalStateException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_missingClientID);
        return objReturn_missingClientID;
    }

    @Override
    public Exception headerTooBig() {
        String returnString = "AMQ339028: Message header too big, increase minLargeMessageSize please.";
        Exception objReturn_headerTooBig = new Exception(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_headerTooBig);
        return objReturn_headerTooBig;
    }

    @Override
    public ActiveMQStompException unknownCommand(String command) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339029: Unsupported command: {}", (Object[])new Object[]{command}).getMessage();
        ActiveMQStompException objReturn_unknownCommand = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_unknownCommand);
        return objReturn_unknownCommand;
    }

    @Override
    public ActiveMQStompException needTxIDHeader() {
        String returnString = "AMQ339030: transaction header is mandatory to COMMIT a transaction";
        ActiveMQStompException objReturn_needTxIDHeader = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_needTxIDHeader);
        return objReturn_needTxIDHeader;
    }

    @Override
    public ActiveMQStompException errorHandleSend(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339031: Error handling send", (Object[])new Object[]{e}).getMessage();
        ActiveMQStompException objReturn_errorHandleSend = new ActiveMQStompException(returnString);
        objReturn_errorHandleSend.initCause(e);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorHandleSend);
        return objReturn_errorHandleSend;
    }

    @Override
    public ActiveMQStompException beginTxNoID() {
        String returnString = "AMQ339032: Need a transaction id to begin";
        ActiveMQStompException objReturn_beginTxNoID = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_beginTxNoID);
        return objReturn_beginTxNoID;
    }

    @Override
    public ActiveMQStompException abortTxNoID() {
        String returnString = "AMQ339033: transaction header is mandatory to ABORT a transaction";
        ActiveMQStompException objReturn_abortTxNoID = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_abortTxNoID);
        return objReturn_abortTxNoID;
    }

    @Override
    public IllegalStateException invalidCall() {
        String returnString = "AMQ339034: This method should not be called";
        IllegalStateException objReturn_invalidCall = new IllegalStateException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidCall);
        return objReturn_invalidCall;
    }

    @Override
    public ActiveMQStompException needIDorDestination() {
        String returnString = "AMQ339035: Must specify the subscription's id or the destination you are unsubscribing from";
        ActiveMQStompException objReturn_needIDorDestination = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_needIDorDestination);
        return objReturn_needIDorDestination;
    }

    @Override
    public ActiveMQStompException needSubscriptionID() {
        String returnString = "AMQ339037: Must specify the subscription's id";
        ActiveMQStompException objReturn_needSubscriptionID = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_needSubscriptionID);
        return objReturn_needSubscriptionID;
    }

    @Override
    public ActiveMQStompException noIDInAck() {
        String returnString = "AMQ339039: No id header in ACK/NACK frame.";
        ActiveMQStompException objReturn_noIDInAck = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_noIDInAck);
        return objReturn_noIDInAck;
    }

    @Override
    public ActiveMQStompException undefinedEscapeSequence(String sequence) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339040: Undefined escape sequence: {}", (Object[])new Object[]{sequence}).getMessage();
        ActiveMQStompException objReturn_undefinedEscapeSequence = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_undefinedEscapeSequence);
        return objReturn_undefinedEscapeSequence;
    }

    @Override
    public ActiveMQStompException illegalSemantics(String requested, String exists) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ339041: Not allowed to specify {} semantics on {} address.", (Object[])new Object[]{requested, exists}).getMessage();
        ActiveMQStompException objReturn_illegalSemantics = new ActiveMQStompException(returnString);
        ActiveMQStompProtocolMessageBundle_impl._copyStackTraceMinusOne(objReturn_illegalSemantics);
        return objReturn_illegalSemantics;
    }
}

