/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.util.function.LongSupplier;

public final class RateSampler
implements Runnable {
    private final LongSupplier sampling;
    private long lastSample;
    private long lastSampleTime;
    private long rate;
    private long timeSpanNs;

    private RateSampler(LongSupplier sampling) {
        this.sampling = sampling;
        this.timeSpanNs = 0L;
        this.lastSampleTime = System.nanoTime();
        this.lastSample = sampling.getAsLong();
        this.rate = 0L;
    }

    @Override
    public void run() {
        long now = System.nanoTime();
        long newSample = this.sampling.getAsLong();
        this.rate = newSample - this.lastSample;
        this.timeSpanNs = now - this.lastSampleTime;
        this.lastSample = newSample;
        this.lastSampleTime = now;
    }

    public long getLastSample() {
        return this.lastSample;
    }

    public long reportRate(long reportIntervalNs) {
        return this.rate * reportIntervalNs / this.timeSpanNs;
    }

    public static RateSampler of(LongSupplier sampling) {
        return new RateSampler(sampling);
    }
}

