/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeQueuePolicyElement;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeQueuePolicy;
import org.apache.qpid.proton.amqp.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBridgeSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static AMQPBridgeManager createManager(AMQPBrokerConnection connection, AMQPBridgeBrokerConnectionElement bridgeElement) {
        Set toQueue;
        Set fromQueue;
        Set toAddress;
        WildcardConfiguration wildcardConfiguration = connection.getServer().getConfiguration().getWildcardConfiguration() != null ? connection.getServer().getConfiguration().getWildcardConfiguration() : WildcardConfiguration.DEFAULT_WILDCARD_CONFIGURATION;
        Set<AMQPBridgeAddressPolicy> fromAddressPolicies = Collections.emptySet();
        Set<AMQPBridgeAddressPolicy> toAddressPolicies = Collections.emptySet();
        Set<AMQPBridgeQueuePolicy> fromQueuePolicies = Collections.emptySet();
        Set<AMQPBridgeQueuePolicy> toQueuePolicies = Collections.emptySet();
        Set fromAddress = bridgeElement.getBridgeFromAddressPolicies();
        if (!fromAddress.isEmpty()) {
            fromAddressPolicies = new HashSet();
            for (AMQPBridgeAddressPolicyElement element : fromAddress) {
                logger.debug("AMQP Bridge {} adding bridge from address policy: {}", (Object)bridgeElement.getName(), (Object)element.getName());
                fromAddressPolicies.add(AMQPBridgeSupport.createBridgeAddressPolicy(element, wildcardConfiguration));
            }
        }
        if (!(toAddress = bridgeElement.getBridgeToAddressPolicies()).isEmpty()) {
            toAddressPolicies = new HashSet();
            for (AMQPBridgeAddressPolicyElement element : toAddress) {
                logger.debug("AMQP Bridge {} adding bridge to address policy: {}", (Object)bridgeElement.getName(), (Object)element.getName());
                toAddressPolicies.add(AMQPBridgeSupport.createBridgeAddressPolicy(element, wildcardConfiguration));
            }
        }
        if (!(fromQueue = bridgeElement.getBridgeFromQueuePolicies()).isEmpty()) {
            fromQueuePolicies = new HashSet();
            for (AMQPBridgeQueuePolicyElement element : fromQueue) {
                logger.debug("AMQP Bridge {} adding bridge from Queue policy: {}", (Object)bridgeElement.getName(), (Object)element.getName());
                fromQueuePolicies.add(AMQPBridgeSupport.createBridgeQueuePolicy(element, wildcardConfiguration));
            }
        }
        if (!(toQueue = bridgeElement.getBridgeToQueuePolicies()).isEmpty()) {
            toQueuePolicies = new HashSet();
            for (AMQPBridgeQueuePolicyElement element : toQueue) {
                logger.debug("AMQP Bridge {} adding bridge to Queue policy: {}", (Object)bridgeElement.getName(), (Object)element.getName());
                toQueuePolicies.add(AMQPBridgeSupport.createBridgeQueuePolicy(element, wildcardConfiguration));
            }
        }
        AMQPBridgeManager bridge = new AMQPBridgeManager(bridgeElement.getName(), connection, fromAddressPolicies, toAddressPolicies, fromQueuePolicies, toQueuePolicies, bridgeElement.getProperties());
        return bridge;
    }

    public static AMQPBridgeQueuePolicy createBridgeQueuePolicy(AMQPBridgeQueuePolicyElement element, WildcardConfiguration wildcards) {
        Set<Map.Entry<String, String>> excludes;
        Set<Map.Entry<String, String>> includes;
        int priorityAdjustment;
        int n = priorityAdjustment = element.getPriorityAdjustment() != null ? element.getPriorityAdjustment() : -1;
        if (element.getIncludes() != null && !element.getIncludes().isEmpty()) {
            includes = new HashSet(element.getIncludes().size());
            element.getIncludes().forEach(queueMatch -> includes.add(new AbstractMap.SimpleImmutableEntry<String, String>(queueMatch.getAddressMatch(), queueMatch.getQueueMatch())));
        } else {
            includes = Collections.emptySet();
        }
        if (element.getExcludes() != null && !element.getExcludes().isEmpty()) {
            excludes = new HashSet(element.getExcludes().size());
            element.getExcludes().forEach(queueMatch -> excludes.add(new AbstractMap.SimpleImmutableEntry<String, String>(queueMatch.getAddressMatch(), queueMatch.getQueueMatch())));
        } else {
            excludes = Collections.emptySet();
        }
        AMQPBridgeQueuePolicy policy = new AMQPBridgeQueuePolicy(element.getName(), element.getPriority(), priorityAdjustment, element.getFilter(), element.getRemoteAddress(), element.getRemoteAddressPrefix(), element.getRemoteAddressSuffix(), AMQPBridgeSupport.toSymbolCollection(element.getRemoteTerminusCapabilities()), includes, excludes, element.getProperties(), element.getTransformerConfiguration(), wildcards);
        return policy;
    }

    public static AMQPBridgeAddressPolicy createBridgeAddressPolicy(AMQPBridgeAddressPolicyElement element, WildcardConfiguration wildcards) {
        Set<String> excludes;
        Set<String> includes;
        if (element.getIncludes() != null && !element.getIncludes().isEmpty()) {
            includes = new HashSet(element.getIncludes().size());
            element.getIncludes().forEach(addressMatch -> includes.add(addressMatch.getAddressMatch()));
        } else {
            includes = Collections.emptySet();
        }
        if (element.getExcludes() != null && !element.getExcludes().isEmpty()) {
            excludes = new HashSet(element.getExcludes().size());
            element.getExcludes().forEach(addressMatch -> excludes.add(addressMatch.getAddressMatch()));
        } else {
            excludes = Collections.emptySet();
        }
        AMQPBridgeAddressPolicy policy = new AMQPBridgeAddressPolicy(element.getName(), element.isIncludeDivertBindings(), element.isUseDurableSubscriptions(), element.getPriority(), element.getFilter(), element.getRemoteAddress(), element.getRemoteAddressPrefix(), element.getRemoteAddressSuffix(), AMQPBridgeSupport.toSymbolCollection(element.getRemoteTerminusCapabilities()), includes, excludes, element.getProperties(), element.getTransformerConfiguration(), wildcards);
        return policy;
    }

    private static Collection<Symbol> toSymbolCollection(String[] symbols) {
        if (symbols == null || symbols.length == 0) {
            return Collections.emptySet();
        }
        HashSet collection = new HashSet(symbols.length);
        for (String symbol : symbols) {
            if (symbol == null || symbol.isBlank()) continue;
            collection.add(Symbol.valueOf((String)symbol));
        }
        return collection.isEmpty() ? Collections.emptySet() : collection;
    }
}

