/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageReader;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonAbstractReceiver;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;

public class AMQPTunneledCoreMessageReader
implements MessageReader {
    private final ProtonAbstractReceiver serverReceiver;
    private boolean closed = true;
    private DeliveryAnnotations deliveryAnnotations;

    public AMQPTunneledCoreMessageReader(ProtonAbstractReceiver serverReceiver) {
        this.serverReceiver = serverReceiver;
    }

    @Override
    public DeliveryAnnotations getDeliveryAnnotations() {
        return this.deliveryAnnotations;
    }

    @Override
    public void close() {
        this.closed = true;
        this.deliveryAnnotations = null;
    }

    @Override
    public MessageReader open() {
        if (!this.closed) {
            throw new IllegalStateException("Message reader must be properly closed before open call");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message readBytes(Delivery delivery) {
        if (delivery.isPartial()) {
            return null;
        }
        AMQPSessionCallback sessionSPI = this.serverReceiver.getSessionContext().getSessionSPI();
        Receiver receiver = (Receiver)delivery.getLink();
        ReadableBuffer recievedBuffer = receiver.recv();
        if (recievedBuffer.remaining() == 0) {
            throw new IllegalArgumentException("Received empty delivery when expecting a core message encoding");
        }
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setBuffer(recievedBuffer);
        Data payloadData = null;
        try {
            while (recievedBuffer.hasRemaining()) {
                TypeConstructor constructor = decoder.readConstructor();
                if (Header.class.equals((Object)constructor.getTypeClass())) {
                    constructor.skipValue();
                    continue;
                }
                if (DeliveryAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    this.deliveryAnnotations = (DeliveryAnnotations)constructor.readValue();
                    continue;
                }
                if (MessageAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    constructor.skipValue();
                    continue;
                }
                if (Properties.class.equals((Object)constructor.getTypeClass())) {
                    constructor.skipValue();
                    continue;
                }
                if (ApplicationProperties.class.equals((Object)constructor.getTypeClass())) {
                    constructor.skipValue();
                    continue;
                }
                if (Data.class.equals((Object)constructor.getTypeClass())) {
                    if (payloadData != null) {
                        throw new IllegalArgumentException("Received an unexpected additional Data section in core tunneled AMQP message");
                    }
                    payloadData = (Data)constructor.readValue();
                    continue;
                }
                if (AmqpValue.class.equals((Object)constructor.getTypeClass())) {
                    throw new IllegalArgumentException("Received an AmqpValue payload in core tunneled AMQP message");
                }
                if (AmqpSequence.class.equals((Object)constructor.getTypeClass())) {
                    throw new IllegalArgumentException("Received an AmqpSequence payload in core tunneled AMQP message");
                }
                if (!Footer.class.equals((Object)constructor.getTypeClass())) continue;
                if (payloadData == null) {
                    throw new IllegalArgumentException("Received an Footer but no actual message payload in core tunneled AMQP message");
                }
                constructor.skipValue();
            }
        }
        finally {
            decoder.setBuffer(null);
        }
        if (payloadData == null) {
            throw new IllegalArgumentException("Did not receive a Data section payload in core tunneled AMQP message");
        }
        Binary payloadBinary = payloadData.getValue();
        if (payloadBinary == null || payloadBinary.getLength() <= 0) {
            throw new IllegalArgumentException("Received an unexpected empty message payload in core tunneled AMQP message");
        }
        ByteBuffer payload = payloadBinary.asByteBuffer();
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)payload);
        buffer.writerIndex(payload.remaining());
        CoreMessage coreMessage = new CoreMessage(sessionSPI.getCoreMessageObjectPools());
        coreMessage.reloadPersistence(buffer, sessionSPI.getCoreMessageObjectPools());
        coreMessage.setMessageID(sessionSPI.getStorageManager().generateID());
        return coreMessage;
    }
}

