/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeBrokerConnectionElement;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBridgeManagers {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Collection<AMQPBridgeManager> bridgeManagers = new ConcurrentHashSet();
    private final AMQPBrokerConnection brokerConnection;

    public AMQPBridgeManagers(AMQPBrokerConnection brokerConnection) {
        this.brokerConnection = brokerConnection;
    }

    public void shutdown() {
        this.bridgeManagers.forEach(bridgeManager -> {
            try {
                bridgeManager.shutdown();
            }
            catch (Exception e) {
                logger.trace("Ignoring exception thrown during bridge manager shutdown: ", (Throwable)e);
            }
        });
        this.bridgeManagers.clear();
    }

    public void start() throws Exception {
        for (AMQPBridgeManager manager : this.bridgeManagers) {
            try {
                manager.start();
            }
            catch (Exception e) {
                logger.debug("Exception thrown during bridge manager start: ", (Throwable)e);
                throw e;
            }
        }
    }

    public void stop() throws Exception {
        Exception firstError = null;
        for (AMQPBridgeManager manager : this.bridgeManagers) {
            try {
                manager.stop();
            }
            catch (Exception e) {
                logger.debug("Exception thrown during bridge manager stop: ", (Throwable)e);
                if (firstError != null) continue;
                firstError = e;
            }
        }
        if (firstError != null) {
            throw firstError;
        }
    }

    public void addBridgeManager(AMQPBridgeBrokerConnectionElement configuration) throws ActiveMQException {
        AMQPBridgeManager bridgeManager = AMQPBridgeSupport.createManager(this.brokerConnection, configuration);
        try {
            bridgeManager.initialize();
        }
        catch (ActiveMQException e) {
            logger.debug("Error caught and re-thrown while initializing configured bridge connection:", (Throwable)e);
            throw e;
        }
        this.bridgeManagers.add(bridgeManager);
    }

    public void connectionRestored(AMQPSessionContext session) throws ActiveMQException {
        for (AMQPBridgeManager bridgeManager : this.bridgeManagers) {
            try {
                bridgeManager.connectionRestored(session.getAMQPConnectionContext(), session);
            }
            catch (ActiveMQException e) {
                logger.trace("AMQP Bridge connection {} threw an error on handling of connection restored: ", (Object)bridgeManager.getName(), (Object)e);
                throw e;
            }
        }
    }

    public void connectionInterrupted() {
        for (AMQPBridgeManager bridgeManager : this.bridgeManagers) {
            if (bridgeManager == null) continue;
            try {
                bridgeManager.connectionInterrupted();
            }
            catch (ActiveMQException e) {
                logger.trace("AMQP Bridge connection {} threw an error on handling of connection interrupted", (Object)bridgeManager.getName());
            }
        }
    }
}

