/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.ActionType;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.CancelFlightInfoRequest;
import org.apache.arrow.flight.CancelStatus;
import org.apache.arrow.flight.CloseSessionRequest;
import org.apache.arrow.flight.CloseSessionResult;
import org.apache.arrow.flight.FlightConstants;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.GetSessionOptionsRequest;
import org.apache.arrow.flight.GetSessionOptionsResult;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.RenewFlightEndpointRequest;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.SetSessionOptionsRequest;
import org.apache.arrow.flight.SetSessionOptionsResult;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.CancelListener;
import org.apache.arrow.flight.sql.CancelResult;
import org.apache.arrow.flight.sql.CancelStatusListener;
import org.apache.arrow.flight.sql.CloseSessionResultListener;
import org.apache.arrow.flight.sql.FlightEndpointListener;
import org.apache.arrow.flight.sql.FlightSqlUtils;
import org.apache.arrow.flight.sql.GetSessionOptionsResultListener;
import org.apache.arrow.flight.sql.NoResultListener;
import org.apache.arrow.flight.sql.ProtoListener;
import org.apache.arrow.flight.sql.SetSessionOptionsResultListener;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public interface FlightSqlProducer
extends FlightProducer,
AutoCloseable {
    default public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
        Any command = FlightSqlUtils.parseOrThrow(descriptor.getCommand());
        if (command.is(FlightSql.CommandStatementQuery.class)) {
            return this.getFlightInfoStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementQuery.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandStatementSubstraitPlan.class)) {
            return this.getFlightInfoSubstraitPlan(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementSubstraitPlan.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandPreparedStatementQuery.class)) {
            return this.getFlightInfoPreparedStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementQuery.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetCatalogs.class)) {
            return this.getFlightInfoCatalogs(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetCatalogs.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetDbSchemas.class)) {
            return this.getFlightInfoSchemas(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetDbSchemas.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetTables.class)) {
            return this.getFlightInfoTables(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetTables.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetTableTypes.class)) {
            return this.getFlightInfoTableTypes(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetTableTypes.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetSqlInfo.class)) {
            return this.getFlightInfoSqlInfo(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetSqlInfo.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetPrimaryKeys.class)) {
            return this.getFlightInfoPrimaryKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetPrimaryKeys.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetExportedKeys.class)) {
            return this.getFlightInfoExportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetExportedKeys.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetImportedKeys.class)) {
            return this.getFlightInfoImportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetImportedKeys.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetCrossReference.class)) {
            return this.getFlightInfoCrossReference(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetCrossReference.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetXdbcTypeInfo.class)) {
            return this.getFlightInfoTypeInfo(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetXdbcTypeInfo.class), context, descriptor);
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("Unrecognized request: " + command.getTypeUrl()).toRuntimeException();
    }

    default public SchemaResult getSchema(FlightProducer.CallContext context, FlightDescriptor descriptor) {
        Any command = FlightSqlUtils.parseOrThrow(descriptor.getCommand());
        if (command.is(FlightSql.CommandStatementQuery.class)) {
            return this.getSchemaStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementQuery.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandPreparedStatementQuery.class)) {
            return this.getSchemaPreparedStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementQuery.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandStatementSubstraitPlan.class)) {
            return this.getSchemaSubstraitPlan(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementSubstraitPlan.class), context, descriptor);
        }
        if (command.is(FlightSql.CommandGetCatalogs.class)) {
            return new SchemaResult(Schemas.GET_CATALOGS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetCrossReference.class)) {
            return new SchemaResult(Schemas.GET_CROSS_REFERENCE_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetDbSchemas.class)) {
            return new SchemaResult(Schemas.GET_SCHEMAS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetExportedKeys.class)) {
            return new SchemaResult(Schemas.GET_EXPORTED_KEYS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetImportedKeys.class)) {
            return new SchemaResult(Schemas.GET_IMPORTED_KEYS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetPrimaryKeys.class)) {
            return new SchemaResult(Schemas.GET_PRIMARY_KEYS_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetTables.class)) {
            if (FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetTables.class).getIncludeSchema()) {
                return new SchemaResult(Schemas.GET_TABLES_SCHEMA);
            }
            return new SchemaResult(Schemas.GET_TABLES_SCHEMA_NO_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetTableTypes.class)) {
            return new SchemaResult(Schemas.GET_TABLE_TYPES_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetSqlInfo.class)) {
            return new SchemaResult(Schemas.GET_SQL_INFO_SCHEMA);
        }
        if (command.is(FlightSql.CommandGetXdbcTypeInfo.class)) {
            return new SchemaResult(Schemas.GET_TYPE_INFO_SCHEMA);
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("Unrecognized request: " + command.getTypeUrl()).toRuntimeException();
    }

    default public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
        Any command;
        try {
            command = Any.parseFrom((byte[])ticket.getBytes());
        }
        catch (InvalidProtocolBufferException e) {
            listener.error((Throwable)e);
            return;
        }
        if (command.is(FlightSql.TicketStatementQuery.class)) {
            this.getStreamStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.TicketStatementQuery.class), context, listener);
        } else if (command.is(FlightSql.CommandPreparedStatementQuery.class)) {
            this.getStreamPreparedStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementQuery.class), context, listener);
        } else if (command.is(FlightSql.CommandGetCatalogs.class)) {
            this.getStreamCatalogs(context, listener);
        } else if (command.is(FlightSql.CommandGetDbSchemas.class)) {
            this.getStreamSchemas(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetDbSchemas.class), context, listener);
        } else if (command.is(FlightSql.CommandGetTables.class)) {
            this.getStreamTables(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetTables.class), context, listener);
        } else if (command.is(FlightSql.CommandGetTableTypes.class)) {
            this.getStreamTableTypes(context, listener);
        } else if (command.is(FlightSql.CommandGetSqlInfo.class)) {
            this.getStreamSqlInfo(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetSqlInfo.class), context, listener);
        } else if (command.is(FlightSql.CommandGetPrimaryKeys.class)) {
            this.getStreamPrimaryKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetPrimaryKeys.class), context, listener);
        } else if (command.is(FlightSql.CommandGetExportedKeys.class)) {
            this.getStreamExportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetExportedKeys.class), context, listener);
        } else if (command.is(FlightSql.CommandGetImportedKeys.class)) {
            this.getStreamImportedKeys(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetImportedKeys.class), context, listener);
        } else if (command.is(FlightSql.CommandGetCrossReference.class)) {
            this.getStreamCrossReference(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetCrossReference.class), context, listener);
        } else if (command.is(FlightSql.CommandGetXdbcTypeInfo.class)) {
            this.getStreamTypeInfo(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandGetXdbcTypeInfo.class), context, listener);
        } else {
            throw CallStatus.INVALID_ARGUMENT.withDescription("The defined request is invalid.").toRuntimeException();
        }
    }

    default public Runnable acceptPut(FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        Any command = FlightSqlUtils.parseOrThrow(flightStream.getDescriptor().getCommand());
        if (command.is(FlightSql.CommandStatementUpdate.class)) {
            return this.acceptPutStatement(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementUpdate.class), context, flightStream, ackStream);
        }
        if (command.is(FlightSql.CommandStatementSubstraitPlan.class)) {
            return this.acceptPutSubstraitPlan(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandStatementSubstraitPlan.class), context, flightStream, ackStream);
        }
        if (command.is(FlightSql.CommandPreparedStatementUpdate.class)) {
            return this.acceptPutPreparedStatementUpdate(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementUpdate.class), context, flightStream, ackStream);
        }
        if (command.is(FlightSql.CommandPreparedStatementQuery.class)) {
            return this.acceptPutPreparedStatementQuery(FlightSqlUtils.unpackOrThrow(command, FlightSql.CommandPreparedStatementQuery.class), context, flightStream, ackStream);
        }
        throw CallStatus.INVALID_ARGUMENT.withDescription("The defined request is invalid.").toRuntimeException();
    }

    default public void listActions(FlightProducer.CallContext context, FlightProducer.StreamListener<ActionType> listener) {
        FlightSqlUtils.FLIGHT_SQL_ACTIONS.forEach(arg_0 -> listener.onNext(arg_0));
        listener.onCompleted();
    }

    default public void doAction(FlightProducer.CallContext context, Action action, FlightProducer.StreamListener<Result> listener) {
        String actionType = action.getType();
        if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_BEGIN_SAVEPOINT.getType())) {
            FlightSql.ActionBeginSavepointRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionBeginSavepointRequest.class);
            this.beginSavepoint(request, context, new ProtoListener<FlightSql.ActionBeginSavepointResult>(listener));
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_BEGIN_TRANSACTION.getType())) {
            FlightSql.ActionBeginTransactionRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionBeginTransactionRequest.class);
            this.beginTransaction(request, context, new ProtoListener<FlightSql.ActionBeginTransactionResult>(listener));
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_CANCEL_QUERY.getType())) {
            FlightInfo info;
            FlightSql.ActionCancelQueryRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionCancelQueryRequest.class);
            try {
                info = FlightInfo.deserialize((ByteBuffer)request.getInfo().asReadOnlyByteBuffer());
            }
            catch (IOException | URISyntaxException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Could not unpack FlightInfo: " + e).withCause((Throwable)e).toRuntimeException());
                return;
            }
            this.cancelQuery(info, context, new CancelListener(listener));
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_CREATE_PREPARED_STATEMENT.getType())) {
            FlightSql.ActionCreatePreparedStatementRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionCreatePreparedStatementRequest.class);
            this.createPreparedStatement(request, context, listener);
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_CREATE_PREPARED_SUBSTRAIT_PLAN.getType())) {
            FlightSql.ActionCreatePreparedSubstraitPlanRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionCreatePreparedSubstraitPlanRequest.class);
            this.createPreparedSubstraitPlan(request, context, new ProtoListener<FlightSql.ActionCreatePreparedStatementResult>(listener));
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_CLOSE_PREPARED_STATEMENT.getType())) {
            FlightSql.ActionClosePreparedStatementRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionClosePreparedStatementRequest.class);
            this.closePreparedStatement(request, context, new NoResultListener(listener));
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_END_SAVEPOINT.getType())) {
            FlightSql.ActionEndSavepointRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionEndSavepointRequest.class);
            this.endSavepoint(request, context, new NoResultListener(listener));
        } else if (actionType.equals(FlightSqlUtils.FLIGHT_SQL_END_TRANSACTION.getType())) {
            FlightSql.ActionEndTransactionRequest request = FlightSqlUtils.unpackAndParseOrThrow(action.getBody(), FlightSql.ActionEndTransactionRequest.class);
            this.endTransaction(request, context, new NoResultListener(listener));
        } else if (actionType.equals(FlightConstants.CANCEL_FLIGHT_INFO.getType())) {
            CancelFlightInfoRequest request;
            try {
                request = CancelFlightInfoRequest.deserialize((ByteBuffer)ByteBuffer.wrap(action.getBody()));
            }
            catch (IOException | URISyntaxException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Could not unpack FlightInfo: " + e).withCause((Throwable)e).toRuntimeException());
                return;
            }
            this.cancelFlightInfo(request, context, new CancelStatusListener(listener));
        } else if (actionType.equals(FlightConstants.RENEW_FLIGHT_ENDPOINT.getType())) {
            RenewFlightEndpointRequest request;
            try {
                request = RenewFlightEndpointRequest.deserialize((ByteBuffer)ByteBuffer.wrap(action.getBody()));
            }
            catch (IOException | URISyntaxException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Could not unpack FlightInfo: " + e).withCause((Throwable)e).toRuntimeException());
                return;
            }
            this.renewFlightEndpoint(request, context, new FlightEndpointListener(listener));
        } else if (actionType.equals(FlightConstants.SET_SESSION_OPTIONS.getType())) {
            SetSessionOptionsRequest request;
            try {
                request = SetSessionOptionsRequest.deserialize((ByteBuffer)ByteBuffer.wrap(action.getBody()));
            }
            catch (IOException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Could not unpack SetSessionOptionsRequest: " + e).withCause((Throwable)e).toRuntimeException());
                return;
            }
            this.setSessionOptions(request, context, new SetSessionOptionsResultListener(listener));
        } else if (actionType.equals(FlightConstants.GET_SESSION_OPTIONS.getType())) {
            GetSessionOptionsRequest request;
            try {
                request = GetSessionOptionsRequest.deserialize((ByteBuffer)ByteBuffer.wrap(action.getBody()));
            }
            catch (IOException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Could not unpack GetSessionOptionsRequest: " + e).withCause((Throwable)e).toRuntimeException());
                return;
            }
            this.getSessionOptions(request, context, new GetSessionOptionsResultListener(listener));
        } else if (actionType.equals(FlightConstants.CLOSE_SESSION.getType())) {
            CloseSessionRequest request;
            try {
                request = CloseSessionRequest.deserialize((ByteBuffer)ByteBuffer.wrap(action.getBody()));
            }
            catch (IOException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withDescription("Could not unpack CloseSessionRequest: " + e).withCause((Throwable)e).toRuntimeException());
                return;
            }
            this.closeSession(request, context, new CloseSessionResultListener(listener));
        } else {
            throw CallStatus.INVALID_ARGUMENT.withDescription("Unrecognized request: " + action.getType()).toRuntimeException();
        }
    }

    default public void beginSavepoint(FlightSql.ActionBeginSavepointRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<FlightSql.ActionBeginSavepointResult> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    default public void beginTransaction(FlightSql.ActionBeginTransactionRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<FlightSql.ActionBeginTransactionResult> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    default public void cancelFlightInfo(CancelFlightInfoRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<CancelStatus> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    @Deprecated
    default public void cancelQuery(FlightInfo info, FlightProducer.CallContext context, final FlightProducer.StreamListener<CancelResult> listener) {
        CancelFlightInfoRequest request = new CancelFlightInfoRequest(info);
        this.cancelFlightInfo(request, context, new FlightProducer.StreamListener<CancelStatus>(){

            public void onNext(CancelStatus val) {
                switch (val) {
                    case UNSPECIFIED: {
                        listener.onNext((Object)CancelResult.UNSPECIFIED);
                        break;
                    }
                    case CANCELLED: {
                        listener.onNext((Object)CancelResult.CANCELLED);
                        break;
                    }
                    case CANCELLING: {
                        listener.onNext((Object)CancelResult.CANCELLING);
                        break;
                    }
                    case NOT_CANCELLABLE: {
                        listener.onNext((Object)CancelResult.NOT_CANCELLABLE);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown enum variant " + val));
                    }
                }
            }

            public void onError(Throwable t) {
                listener.onError(t);
            }

            public void onCompleted() {
                listener.onCompleted();
            }
        });
    }

    default public void setSessionOptions(SetSessionOptionsRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<SetSessionOptionsResult> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    default public void getSessionOptions(GetSessionOptionsRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<GetSessionOptionsResult> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    default public void closeSession(CloseSessionRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<CloseSessionResult> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    public void createPreparedStatement(FlightSql.ActionCreatePreparedStatementRequest var1, FlightProducer.CallContext var2, FlightProducer.StreamListener<Result> var3);

    default public void createPreparedSubstraitPlan(FlightSql.ActionCreatePreparedSubstraitPlanRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<FlightSql.ActionCreatePreparedStatementResult> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    public void closePreparedStatement(FlightSql.ActionClosePreparedStatementRequest var1, FlightProducer.CallContext var2, FlightProducer.StreamListener<Result> var3);

    default public void endSavepoint(FlightSql.ActionEndSavepointRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    default public void endTransaction(FlightSql.ActionEndTransactionRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<Result> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    public FlightInfo getFlightInfoStatement(FlightSql.CommandStatementQuery var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    default public FlightInfo getFlightInfoSubstraitPlan(FlightSql.CommandStatementSubstraitPlan command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        throw CallStatus.UNIMPLEMENTED.toRuntimeException();
    }

    public FlightInfo getFlightInfoPreparedStatement(FlightSql.CommandPreparedStatementQuery var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public SchemaResult getSchemaStatement(FlightSql.CommandStatementQuery var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    default public SchemaResult getSchemaPreparedStatement(FlightSql.CommandPreparedStatementQuery command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        throw CallStatus.UNIMPLEMENTED.withDescription("GetSchema with CommandPreparedStatementQuery is not implemented").toRuntimeException();
    }

    default public SchemaResult getSchemaSubstraitPlan(FlightSql.CommandStatementSubstraitPlan command, FlightProducer.CallContext context, FlightDescriptor descriptor) {
        throw CallStatus.UNIMPLEMENTED.toRuntimeException();
    }

    public void getStreamStatement(FlightSql.TicketStatementQuery var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public void getStreamPreparedStatement(FlightSql.CommandPreparedStatementQuery var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public Runnable acceptPutStatement(FlightSql.CommandStatementUpdate var1, FlightProducer.CallContext var2, FlightStream var3, FlightProducer.StreamListener<PutResult> var4);

    default public Runnable acceptPutSubstraitPlan(FlightSql.CommandStatementSubstraitPlan command, FlightProducer.CallContext context, FlightStream flightStream, FlightProducer.StreamListener<PutResult> ackStream) {
        return () -> ackStream.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    public Runnable acceptPutPreparedStatementUpdate(FlightSql.CommandPreparedStatementUpdate var1, FlightProducer.CallContext var2, FlightStream var3, FlightProducer.StreamListener<PutResult> var4);

    public Runnable acceptPutPreparedStatementQuery(FlightSql.CommandPreparedStatementQuery var1, FlightProducer.CallContext var2, FlightStream var3, FlightProducer.StreamListener<PutResult> var4);

    public FlightInfo getFlightInfoSqlInfo(FlightSql.CommandGetSqlInfo var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamSqlInfo(FlightSql.CommandGetSqlInfo var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoTypeInfo(FlightSql.CommandGetXdbcTypeInfo var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamTypeInfo(FlightSql.CommandGetXdbcTypeInfo var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoCatalogs(FlightSql.CommandGetCatalogs var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamCatalogs(FlightProducer.CallContext var1, FlightProducer.ServerStreamListener var2);

    public FlightInfo getFlightInfoSchemas(FlightSql.CommandGetDbSchemas var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamSchemas(FlightSql.CommandGetDbSchemas var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoTables(FlightSql.CommandGetTables var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamTables(FlightSql.CommandGetTables var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoTableTypes(FlightSql.CommandGetTableTypes var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamTableTypes(FlightProducer.CallContext var1, FlightProducer.ServerStreamListener var2);

    public FlightInfo getFlightInfoPrimaryKeys(FlightSql.CommandGetPrimaryKeys var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamPrimaryKeys(FlightSql.CommandGetPrimaryKeys var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public FlightInfo getFlightInfoExportedKeys(FlightSql.CommandGetExportedKeys var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public FlightInfo getFlightInfoImportedKeys(FlightSql.CommandGetImportedKeys var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public FlightInfo getFlightInfoCrossReference(FlightSql.CommandGetCrossReference var1, FlightProducer.CallContext var2, FlightDescriptor var3);

    public void getStreamExportedKeys(FlightSql.CommandGetExportedKeys var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public void getStreamImportedKeys(FlightSql.CommandGetImportedKeys var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    public void getStreamCrossReference(FlightSql.CommandGetCrossReference var1, FlightProducer.CallContext var2, FlightProducer.ServerStreamListener var3);

    default public void renewFlightEndpoint(RenewFlightEndpointRequest request, FlightProducer.CallContext context, FlightProducer.StreamListener<FlightEndpoint> listener) {
        listener.onError((Throwable)CallStatus.UNIMPLEMENTED.toRuntimeException());
    }

    public static final class Schemas {
        public static final Schema GET_TABLES_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_type", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_schema", (ArrowType)Types.MinorType.VARBINARY.getType())));
        public static final Schema GET_TABLES_SCHEMA_NO_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_type", (ArrowType)Types.MinorType.VARCHAR.getType())));
        public static final Schema GET_CATALOGS_SCHEMA = new Schema(Collections.singletonList(Field.notNullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType())));
        public static final Schema GET_TABLE_TYPES_SCHEMA = new Schema(Collections.singletonList(Field.notNullable((String)"table_type", (ArrowType)Types.MinorType.VARCHAR.getType())));
        public static final Schema GET_SCHEMAS_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType())));
        private static final Schema GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA;
        public static final Schema GET_IMPORTED_KEYS_SCHEMA;
        public static final Schema GET_EXPORTED_KEYS_SCHEMA;
        public static final Schema GET_CROSS_REFERENCE_SCHEMA;
        private static final List<Field> GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS;
        public static final Schema GET_SQL_INFO_SCHEMA;
        public static final Schema GET_TYPE_INFO_SCHEMA;
        public static final Schema GET_PRIMARY_KEYS_SCHEMA;

        private Schemas() {
        }

        static {
            GET_IMPORTED_KEYS_SCHEMA = GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"pk_catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"pk_db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"pk_table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"pk_column_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"fk_catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"fk_db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"fk_table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"fk_column_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"key_sequence", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"fk_key_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"pk_key_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"update_rule", (ArrowType)Types.MinorType.UINT1.getType()), Field.notNullable((String)"delete_rule", (ArrowType)Types.MinorType.UINT1.getType())));
            GET_EXPORTED_KEYS_SCHEMA = GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA;
            GET_CROSS_REFERENCE_SCHEMA = GET_IMPORTED_EXPORTED_AND_CROSS_REFERENCE_KEYS_SCHEMA;
            GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS = Arrays.asList(Field.notNullable((String)"string_value", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"bool_value", (ArrowType)Types.MinorType.BIT.getType()), Field.notNullable((String)"bigint_value", (ArrowType)Types.MinorType.BIGINT.getType()), Field.notNullable((String)"int32_bitmask", (ArrowType)Types.MinorType.INT.getType()), new Field("string_list", FieldType.notNullable((ArrowType)Types.MinorType.LIST.getType()), Collections.singletonList(Field.nullable((String)"item", (ArrowType)Types.MinorType.VARCHAR.getType()))), new Field("int32_to_int32_list_map", FieldType.notNullable((ArrowType)new ArrowType.Map(false)), Collections.singletonList(new Field("entries", new FieldType(false, Types.MinorType.STRUCT.getType(), null), (List)ImmutableList.of((Object)Field.notNullable((String)"key", (ArrowType)Types.MinorType.INT.getType()), (Object)new Field("value", FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), Collections.singletonList(Field.nullable((String)"item", (ArrowType)Types.MinorType.INT.getType()))))))));
            GET_SQL_INFO_SCHEMA = new Schema(Arrays.asList(Field.notNullable((String)"info_name", (ArrowType)Types.MinorType.UINT4.getType()), new Field("value", FieldType.notNullable((ArrowType)new ArrowType.Union(UnionMode.Dense, IntStream.range(0, GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS.size()).toArray())), GET_SQL_INFO_DENSE_UNION_SCHEMA_FIELDS)));
            GET_TYPE_INFO_SCHEMA = new Schema(Arrays.asList(Field.notNullable((String)"type_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"data_type", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"column_size", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"literal_prefix", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"literal_suffix", (ArrowType)Types.MinorType.VARCHAR.getType()), new Field("create_params", FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), Collections.singletonList(Field.notNullable((String)"item", (ArrowType)Types.MinorType.VARCHAR.getType()))), Field.notNullable((String)"nullable", (ArrowType)Types.MinorType.INT.getType()), Field.notNullable((String)"case_sensitive", (ArrowType)Types.MinorType.BIT.getType()), Field.notNullable((String)"searchable", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"unsigned_attribute", (ArrowType)Types.MinorType.BIT.getType()), Field.notNullable((String)"fixed_prec_scale", (ArrowType)Types.MinorType.BIT.getType()), Field.nullable((String)"auto_increment", (ArrowType)Types.MinorType.BIT.getType()), Field.nullable((String)"local_type_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"minimum_scale", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"maximum_scale", (ArrowType)Types.MinorType.INT.getType()), Field.notNullable((String)"sql_data_type", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"datetime_subcode", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"num_prec_radix", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"interval_precision", (ArrowType)Types.MinorType.INT.getType())));
            GET_PRIMARY_KEYS_SCHEMA = new Schema(Arrays.asList(Field.nullable((String)"catalog_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.nullable((String)"db_schema_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"table_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"column_name", (ArrowType)Types.MinorType.VARCHAR.getType()), Field.notNullable((String)"key_sequence", (ArrowType)Types.MinorType.INT.getType()), Field.nullable((String)"key_name", (ArrowType)Types.MinorType.VARCHAR.getType())));
        }
    }
}

