/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.sql;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.CancelFlightInfoRequest;
import org.apache.arrow.flight.CancelFlightInfoResult;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.RenewFlightEndpointRequest;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.flight.SyncPutListener;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.sql.CancelResult;
import org.apache.arrow.flight.sql.FlightSqlUtils;
import org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.flight.sql.util.TableRef;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;

public class FlightSqlClient
implements AutoCloseable {
    private final FlightClient client;

    public FlightSqlClient(FlightClient client) {
        this.client = Objects.requireNonNull(client, "Client cannot be null!");
    }

    public FlightInfo execute(String query, CallOption ... options) {
        return this.execute(query, (Transaction)null, options);
    }

    public FlightInfo execute(String query, Transaction transaction, CallOption ... options) {
        FlightSql.CommandStatementQuery.Builder builder = FlightSql.CommandStatementQuery.newBuilder().setQuery(query);
        if (transaction != null) {
            builder.setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId()));
        }
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo executeSubstrait(SubstraitPlan plan, CallOption ... options) {
        return this.executeSubstrait(plan, (Transaction)null, options);
    }

    public FlightInfo executeSubstrait(SubstraitPlan plan, Transaction transaction, CallOption ... options) {
        FlightSql.CommandStatementSubstraitPlan.Builder builder = FlightSql.CommandStatementSubstraitPlan.newBuilder();
        builder.getPlanBuilder().setPlan(ByteString.copyFrom((byte[])plan.getPlan())).setVersion(plan.getVersion());
        if (transaction != null) {
            builder.setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId()));
        }
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getExecuteSchema(String query, Transaction transaction, CallOption ... options) {
        FlightSql.CommandStatementQuery.Builder builder = FlightSql.CommandStatementQuery.newBuilder();
        builder.setQuery(query);
        if (transaction != null) {
            builder.setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId()));
        }
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public SchemaResult getExecuteSchema(String query, CallOption ... options) {
        return this.getExecuteSchema(query, (Transaction)null, options);
    }

    public SchemaResult getExecuteSubstraitSchema(SubstraitPlan plan, Transaction transaction, CallOption ... options) {
        FlightSql.CommandStatementSubstraitPlan.Builder builder = FlightSql.CommandStatementSubstraitPlan.newBuilder();
        builder.getPlanBuilder().setPlan(ByteString.copyFrom((byte[])plan.getPlan())).setVersion(plan.getVersion());
        if (transaction != null) {
            builder.setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId()));
        }
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public SchemaResult getExecuteSubstraitSchema(SubstraitPlan substraitPlan, CallOption ... options) {
        return this.getExecuteSubstraitSchema(substraitPlan, (Transaction)null, options);
    }

    public long executeUpdate(String query, CallOption ... options) {
        return this.executeUpdate(query, (Transaction)null, options);
    }

    /*
     * Exception decompiling
     */
    public long executeUpdate(String query, Transaction transaction, CallOption ... options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long executeSubstraitUpdate(SubstraitPlan plan, CallOption ... options) {
        return this.executeSubstraitUpdate(plan, (Transaction)null, options);
    }

    /*
     * Exception decompiling
     */
    public long executeSubstraitUpdate(SubstraitPlan plan, Transaction transaction, CallOption ... options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FlightInfo getCatalogs(CallOption ... options) {
        FlightSql.CommandGetCatalogs.Builder builder = FlightSql.CommandGetCatalogs.newBuilder();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getCatalogsSchema(CallOption ... options) {
        FlightSql.CommandGetCatalogs command = FlightSql.CommandGetCatalogs.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getSchemas(String catalog, String dbSchemaFilterPattern, CallOption ... options) {
        FlightSql.CommandGetDbSchemas.Builder builder = FlightSql.CommandGetDbSchemas.newBuilder();
        if (catalog != null) {
            builder.setCatalog(catalog);
        }
        if (dbSchemaFilterPattern != null) {
            builder.setDbSchemaFilterPattern(dbSchemaFilterPattern);
        }
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getSchemasSchema(CallOption ... options) {
        FlightSql.CommandGetDbSchemas command = FlightSql.CommandGetDbSchemas.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public SchemaResult getSchema(FlightDescriptor descriptor, CallOption ... options) {
        return this.client.getSchema(descriptor, options);
    }

    public FlightStream getStream(Ticket ticket, CallOption ... options) {
        return this.client.getStream(ticket, options);
    }

    public FlightInfo getSqlInfo(FlightSql.SqlInfo ... info) {
        return this.getSqlInfo(info, new CallOption[0]);
    }

    public FlightInfo getSqlInfo(FlightSql.SqlInfo[] info, CallOption ... options) {
        int[] infoNumbers = Arrays.stream(info).mapToInt(FlightSql.SqlInfo::getNumber).toArray();
        return this.getSqlInfo(infoNumbers, options);
    }

    public FlightInfo getSqlInfo(int[] info, CallOption ... options) {
        return this.getSqlInfo(Arrays.stream(info).boxed().collect(Collectors.toList()), options);
    }

    public FlightInfo getSqlInfo(Iterable<Integer> info, CallOption ... options) {
        FlightSql.CommandGetSqlInfo.Builder builder = FlightSql.CommandGetSqlInfo.newBuilder();
        builder.addAllInfo(info);
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getSqlInfoSchema(CallOption ... options) {
        FlightSql.CommandGetSqlInfo command = FlightSql.CommandGetSqlInfo.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getXdbcTypeInfo(int dataType, CallOption ... options) {
        FlightSql.CommandGetXdbcTypeInfo.Builder builder = FlightSql.CommandGetXdbcTypeInfo.newBuilder();
        builder.setDataType(dataType);
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public FlightInfo getXdbcTypeInfo(CallOption ... options) {
        FlightSql.CommandGetXdbcTypeInfo.Builder builder = FlightSql.CommandGetXdbcTypeInfo.newBuilder();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getXdbcTypeInfoSchema(CallOption ... options) {
        FlightSql.CommandGetXdbcTypeInfo command = FlightSql.CommandGetXdbcTypeInfo.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getTables(String catalog, String dbSchemaFilterPattern, String tableFilterPattern, List<String> tableTypes, boolean includeSchema, CallOption ... options) {
        FlightSql.CommandGetTables.Builder builder = FlightSql.CommandGetTables.newBuilder();
        if (catalog != null) {
            builder.setCatalog(catalog);
        }
        if (dbSchemaFilterPattern != null) {
            builder.setDbSchemaFilterPattern(dbSchemaFilterPattern);
        }
        if (tableFilterPattern != null) {
            builder.setTableNameFilterPattern(tableFilterPattern);
        }
        if (tableTypes != null) {
            builder.addAllTableTypes(tableTypes);
        }
        builder.setIncludeSchema(includeSchema);
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getTablesSchema(boolean includeSchema, CallOption ... options) {
        FlightSql.CommandGetTables command = FlightSql.CommandGetTables.newBuilder().setIncludeSchema(includeSchema).build();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getPrimaryKeys(TableRef tableRef, CallOption ... options) {
        FlightSql.CommandGetPrimaryKeys.Builder builder = FlightSql.CommandGetPrimaryKeys.newBuilder();
        if (tableRef.getCatalog() != null) {
            builder.setCatalog(tableRef.getCatalog());
        }
        if (tableRef.getDbSchema() != null) {
            builder.setDbSchema(tableRef.getDbSchema());
        }
        Objects.requireNonNull(tableRef.getTable());
        builder.setTable(tableRef.getTable());
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getPrimaryKeysSchema(CallOption ... options) {
        FlightSql.CommandGetPrimaryKeys command = FlightSql.CommandGetPrimaryKeys.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getExportedKeys(TableRef tableRef, CallOption ... options) {
        Objects.requireNonNull(tableRef.getTable(), "Table cannot be null.");
        FlightSql.CommandGetExportedKeys.Builder builder = FlightSql.CommandGetExportedKeys.newBuilder();
        if (tableRef.getCatalog() != null) {
            builder.setCatalog(tableRef.getCatalog());
        }
        if (tableRef.getDbSchema() != null) {
            builder.setDbSchema(tableRef.getDbSchema());
        }
        Objects.requireNonNull(tableRef.getTable());
        builder.setTable(tableRef.getTable());
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getExportedKeysSchema(CallOption ... options) {
        FlightSql.CommandGetExportedKeys command = FlightSql.CommandGetExportedKeys.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getImportedKeys(TableRef tableRef, CallOption ... options) {
        Objects.requireNonNull(tableRef.getTable(), "Table cannot be null.");
        FlightSql.CommandGetImportedKeys.Builder builder = FlightSql.CommandGetImportedKeys.newBuilder();
        if (tableRef.getCatalog() != null) {
            builder.setCatalog(tableRef.getCatalog());
        }
        if (tableRef.getDbSchema() != null) {
            builder.setDbSchema(tableRef.getDbSchema());
        }
        Objects.requireNonNull(tableRef.getTable());
        builder.setTable(tableRef.getTable());
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getImportedKeysSchema(CallOption ... options) {
        FlightSql.CommandGetImportedKeys command = FlightSql.CommandGetImportedKeys.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getCrossReference(TableRef pkTableRef, TableRef fkTableRef, CallOption ... options) {
        Objects.requireNonNull(pkTableRef.getTable(), "Parent Table cannot be null.");
        Objects.requireNonNull(fkTableRef.getTable(), "Foreign Table cannot be null.");
        FlightSql.CommandGetCrossReference.Builder builder = FlightSql.CommandGetCrossReference.newBuilder();
        if (pkTableRef.getCatalog() != null) {
            builder.setPkCatalog(pkTableRef.getCatalog());
        }
        if (pkTableRef.getDbSchema() != null) {
            builder.setPkDbSchema(pkTableRef.getDbSchema());
        }
        if (fkTableRef.getCatalog() != null) {
            builder.setFkCatalog(fkTableRef.getCatalog());
        }
        if (fkTableRef.getDbSchema() != null) {
            builder.setFkDbSchema(fkTableRef.getDbSchema());
        }
        builder.setPkTable(pkTableRef.getTable());
        builder.setFkTable(fkTableRef.getTable());
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getCrossReferenceSchema(CallOption ... options) {
        FlightSql.CommandGetCrossReference command = FlightSql.CommandGetCrossReference.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public FlightInfo getTableTypes(CallOption ... options) {
        FlightSql.CommandGetTableTypes.Builder builder = FlightSql.CommandGetTableTypes.newBuilder();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)builder.build()).toByteArray());
        return this.client.getInfo(descriptor, options);
    }

    public SchemaResult getTableTypesSchema(CallOption ... options) {
        FlightSql.CommandGetTableTypes command = FlightSql.CommandGetTableTypes.getDefaultInstance();
        FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)command).toByteArray());
        return this.client.getSchema(descriptor, options);
    }

    public PreparedStatement prepare(String query, CallOption ... options) {
        return this.prepare(query, (Transaction)null, options);
    }

    public PreparedStatement prepare(String query, Transaction transaction, CallOption ... options) {
        FlightSql.ActionCreatePreparedStatementRequest.Builder builder = FlightSql.ActionCreatePreparedStatementRequest.newBuilder().setQuery(query);
        if (transaction != null) {
            builder.setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId()));
        }
        return new PreparedStatement(this.client, new Action(FlightSqlUtils.FLIGHT_SQL_CREATE_PREPARED_STATEMENT.getType(), Any.pack((Message)builder.build()).toByteArray()), options);
    }

    public PreparedStatement prepare(SubstraitPlan plan, CallOption ... options) {
        return this.prepare(plan, (Transaction)null, options);
    }

    public PreparedStatement prepare(SubstraitPlan plan, Transaction transaction, CallOption ... options) {
        FlightSql.ActionCreatePreparedSubstraitPlanRequest.Builder builder = FlightSql.ActionCreatePreparedSubstraitPlanRequest.newBuilder();
        builder.getPlanBuilder().setPlan(ByteString.copyFrom((byte[])plan.getPlan())).setVersion(plan.getVersion());
        if (transaction != null) {
            builder.setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId()));
        }
        return new PreparedStatement(this.client, new Action(FlightSqlUtils.FLIGHT_SQL_CREATE_PREPARED_SUBSTRAIT_PLAN.getType(), Any.pack((Message)builder.build()).toByteArray()), options);
    }

    public Transaction beginTransaction(CallOption ... options) {
        Action action = new Action(FlightSqlUtils.FLIGHT_SQL_BEGIN_TRANSACTION.getType(), Any.pack((Message)FlightSql.ActionBeginTransactionRequest.getDefaultInstance()).toByteArray());
        Iterator preparedStatementResults = this.client.doAction(action, options);
        FlightSql.ActionBeginTransactionResult result = FlightSqlUtils.unpackAndParseOrThrow(((Result)preparedStatementResults.next()).getBody(), FlightSql.ActionBeginTransactionResult.class);
        preparedStatementResults.forEachRemaining(ignored -> {});
        if (result.getTransactionId().isEmpty()) {
            throw CallStatus.INTERNAL.withDescription("Server returned an empty transaction ID").toRuntimeException();
        }
        return new Transaction(result.getTransactionId().toByteArray());
    }

    public Savepoint beginSavepoint(Transaction transaction, String name, CallOption ... options) {
        Preconditions.checkArgument((transaction.getTransactionId().length != 0 ? 1 : 0) != 0, (Object)"Transaction must be initialized");
        FlightSql.ActionBeginSavepointRequest request = FlightSql.ActionBeginSavepointRequest.newBuilder().setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId())).setName(name).build();
        Action action = new Action(FlightSqlUtils.FLIGHT_SQL_BEGIN_SAVEPOINT.getType(), Any.pack((Message)request).toByteArray());
        Iterator preparedStatementResults = this.client.doAction(action, options);
        FlightSql.ActionBeginSavepointResult result = FlightSqlUtils.unpackAndParseOrThrow(((Result)preparedStatementResults.next()).getBody(), FlightSql.ActionBeginSavepointResult.class);
        preparedStatementResults.forEachRemaining(ignored -> {});
        if (result.getSavepointId().isEmpty()) {
            throw CallStatus.INTERNAL.withDescription("Server returned an empty transaction ID").toRuntimeException();
        }
        return new Savepoint(result.getSavepointId().toByteArray());
    }

    public void commit(Transaction transaction, CallOption ... options) {
        Preconditions.checkArgument((transaction.getTransactionId().length != 0 ? 1 : 0) != 0, (Object)"Transaction must be initialized");
        FlightSql.ActionEndTransactionRequest request = FlightSql.ActionEndTransactionRequest.newBuilder().setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId())).setActionValue(FlightSql.ActionEndTransactionRequest.EndTransaction.END_TRANSACTION_COMMIT.getNumber()).build();
        Action action = new Action(FlightSqlUtils.FLIGHT_SQL_END_TRANSACTION.getType(), Any.pack((Message)request).toByteArray());
        Iterator preparedStatementResults = this.client.doAction(action, options);
        preparedStatementResults.forEachRemaining(ignored -> {});
    }

    public void release(Savepoint savepoint, CallOption ... options) {
        Preconditions.checkArgument((savepoint.getSavepointId().length != 0 ? 1 : 0) != 0, (Object)"Savepoint must be initialized");
        FlightSql.ActionEndSavepointRequest request = FlightSql.ActionEndSavepointRequest.newBuilder().setSavepointId(ByteString.copyFrom((byte[])savepoint.getSavepointId())).setActionValue(FlightSql.ActionEndSavepointRequest.EndSavepoint.END_SAVEPOINT_RELEASE.getNumber()).build();
        Action action = new Action(FlightSqlUtils.FLIGHT_SQL_END_SAVEPOINT.getType(), Any.pack((Message)request).toByteArray());
        Iterator preparedStatementResults = this.client.doAction(action, options);
        preparedStatementResults.forEachRemaining(ignored -> {});
    }

    public void rollback(Transaction transaction, CallOption ... options) {
        Preconditions.checkArgument((transaction.getTransactionId().length != 0 ? 1 : 0) != 0, (Object)"Transaction must be initialized");
        FlightSql.ActionEndTransactionRequest request = FlightSql.ActionEndTransactionRequest.newBuilder().setTransactionId(ByteString.copyFrom((byte[])transaction.getTransactionId())).setActionValue(FlightSql.ActionEndTransactionRequest.EndTransaction.END_TRANSACTION_ROLLBACK.getNumber()).build();
        Action action = new Action(FlightSqlUtils.FLIGHT_SQL_END_TRANSACTION.getType(), Any.pack((Message)request).toByteArray());
        Iterator preparedStatementResults = this.client.doAction(action, options);
        preparedStatementResults.forEachRemaining(ignored -> {});
    }

    public void rollback(Savepoint savepoint, CallOption ... options) {
        Preconditions.checkArgument((savepoint.getSavepointId().length != 0 ? 1 : 0) != 0, (Object)"Savepoint must be initialized");
        FlightSql.ActionEndSavepointRequest request = FlightSql.ActionEndSavepointRequest.newBuilder().setSavepointId(ByteString.copyFrom((byte[])savepoint.getSavepointId())).setActionValue(FlightSql.ActionEndSavepointRequest.EndSavepoint.END_SAVEPOINT_RELEASE.getNumber()).build();
        Action action = new Action(FlightSqlUtils.FLIGHT_SQL_END_SAVEPOINT.getType(), Any.pack((Message)request).toByteArray());
        Iterator preparedStatementResults = this.client.doAction(action, options);
        preparedStatementResults.forEachRemaining(ignored -> {});
    }

    public CancelFlightInfoResult cancelFlightInfo(CancelFlightInfoRequest request, CallOption ... options) {
        return this.client.cancelFlightInfo(request, options);
    }

    @Deprecated
    public CancelResult cancelQuery(FlightInfo info, CallOption ... options) {
        FlightSql.ActionCancelQueryRequest request = FlightSql.ActionCancelQueryRequest.newBuilder().setInfo(ByteString.copyFrom((ByteBuffer)info.serialize())).build();
        Action action = new Action(FlightSqlUtils.FLIGHT_SQL_CANCEL_QUERY.getType(), Any.pack((Message)request).toByteArray());
        Iterator preparedStatementResults = this.client.doAction(action, options);
        FlightSql.ActionCancelQueryResult result = FlightSqlUtils.unpackAndParseOrThrow(((Result)preparedStatementResults.next()).getBody(), FlightSql.ActionCancelQueryResult.class);
        preparedStatementResults.forEachRemaining(ignored -> {});
        switch (result.getResult()) {
            case CANCEL_RESULT_UNSPECIFIED: {
                return CancelResult.UNSPECIFIED;
            }
            case CANCEL_RESULT_CANCELLED: {
                return CancelResult.CANCELLED;
            }
            case CANCEL_RESULT_CANCELLING: {
                return CancelResult.CANCELLING;
            }
            case CANCEL_RESULT_NOT_CANCELLABLE: {
                return CancelResult.NOT_CANCELLABLE;
            }
        }
        throw CallStatus.INTERNAL.withDescription("Unknown result: " + result.getResult()).toRuntimeException();
    }

    public FlightEndpoint renewFlightEndpoint(RenewFlightEndpointRequest request, CallOption ... options) {
        return this.client.renewFlightEndpoint(request, options);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{this.client});
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static final class SubstraitPlan {
        private final byte[] plan;
        private final String version;

        public SubstraitPlan(byte[] plan, String version) {
            this.plan = (byte[])Preconditions.checkNotNull((Object)plan);
            this.version = (String)Preconditions.checkNotNull((Object)version);
        }

        public byte[] getPlan() {
            return this.plan;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubstraitPlan that = (SubstraitPlan)o;
            if (!Arrays.equals(this.getPlan(), that.getPlan())) {
                return false;
            }
            return this.getVersion().equals(that.getVersion());
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.getPlan());
            result = 31 * result + this.getVersion().hashCode();
            return result;
        }

        public String toString() {
            return "SubstraitPlan{plan=" + Arrays.toString(this.plan) + ", version='" + this.version + '\'' + '}';
        }
    }

    public static class Transaction {
        private final byte[] transactionId;

        public Transaction(byte[] transactionId) {
            this.transactionId = transactionId;
        }

        public byte[] getTransactionId() {
            return this.transactionId;
        }
    }

    public static class Savepoint {
        private final byte[] transactionId;

        public Savepoint(byte[] transactionId) {
            this.transactionId = transactionId;
        }

        public byte[] getSavepointId() {
            return this.transactionId;
        }
    }

    public static class PreparedStatement
    implements AutoCloseable {
        private final FlightClient client;
        private final FlightSql.ActionCreatePreparedStatementResult preparedStatementResult;
        private VectorSchemaRoot parameterBindingRoot;
        private boolean isClosed;
        private Schema resultSetSchema;
        private Schema parameterSchema;

        PreparedStatement(FlightClient client, Action action, CallOption ... options) {
            this.client = client;
            Iterator preparedStatementResults = client.doAction(action, options);
            this.preparedStatementResult = FlightSqlUtils.unpackAndParseOrThrow(((Result)preparedStatementResults.next()).getBody(), FlightSql.ActionCreatePreparedStatementResult.class);
            this.isClosed = false;
        }

        public void setParameters(VectorSchemaRoot parameterBindingRoot) {
            if (parameterBindingRoot == this.parameterBindingRoot) {
                return;
            }
            this.clearParameters();
            this.parameterBindingRoot = parameterBindingRoot;
        }

        public void clearParameters() {
            if (this.parameterBindingRoot != null) {
                this.parameterBindingRoot.close();
            }
        }

        public Schema getResultSetSchema() {
            if (this.resultSetSchema == null) {
                ByteString bytes = this.preparedStatementResult.getDatasetSchema();
                this.resultSetSchema = this.deserializeSchema(bytes);
            }
            return this.resultSetSchema;
        }

        public Schema getParameterSchema() {
            if (this.parameterSchema == null) {
                ByteString bytes = this.preparedStatementResult.getParameterSchema();
                this.parameterSchema = this.deserializeSchema(bytes);
            }
            return this.parameterSchema;
        }

        public SchemaResult fetchSchema(CallOption ... options) {
            this.checkOpen();
            FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)FlightSql.CommandPreparedStatementQuery.newBuilder().setPreparedStatementHandle(this.preparedStatementResult.getPreparedStatementHandle()).build()).toByteArray());
            return this.client.getSchema(descriptor, options);
        }

        private Schema deserializeSchema(ByteString bytes) {
            try {
                return bytes.isEmpty() ? new Schema(Collections.emptyList()) : MessageSerializer.deserializeSchema((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(bytes.toByteArray()))));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to deserialize schema", e);
            }
        }

        public FlightInfo execute(CallOption ... options) {
            this.checkOpen();
            FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)FlightSql.CommandPreparedStatementQuery.newBuilder().setPreparedStatementHandle(this.preparedStatementResult.getPreparedStatementHandle()).build()).toByteArray());
            if (this.parameterBindingRoot != null && this.parameterBindingRoot.getRowCount() > 0) {
                this.putParameters(descriptor, options);
            }
            return this.client.getInfo(descriptor, options);
        }

        private SyncPutListener putParameters(FlightDescriptor descriptor, CallOption ... options) {
            SyncPutListener putListener = new SyncPutListener();
            FlightClient.ClientStreamListener listener = this.client.startPut(descriptor, this.parameterBindingRoot, (FlightClient.PutListener)putListener, options);
            listener.putNext();
            listener.completed();
            listener.getResult();
            return putListener;
        }

        protected final void checkOpen() {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"Statement closed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long executeUpdate(CallOption ... options) {
            this.checkOpen();
            FlightDescriptor descriptor = FlightDescriptor.command((byte[])Any.pack((Message)FlightSql.CommandPreparedStatementUpdate.newBuilder().setPreparedStatementHandle(this.preparedStatementResult.getPreparedStatementHandle()).build()).toByteArray());
            this.setParameters(this.parameterBindingRoot == null ? VectorSchemaRoot.of((FieldVector[])new FieldVector[0]) : this.parameterBindingRoot);
            SyncPutListener putListener = this.putParameters(descriptor, options);
            try {
                PutResult read = putListener.read();
                try (ArrowBuf metadata = read.getApplicationMetadata();){
                    FlightSql.DoPutUpdateResult doPutUpdateResult = FlightSql.DoPutUpdateResult.parseFrom((ByteBuffer)metadata.nioBuffer());
                    long l = doPutUpdateResult.getRecordCount();
                    return l;
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw CallStatus.CANCELLED.withCause((Throwable)e).toRuntimeException();
            }
            catch (InvalidProtocolBufferException e) {
                throw CallStatus.INVALID_ARGUMENT.withCause((Throwable)e).toRuntimeException();
            }
        }

        public void close(CallOption ... options) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            Action action = new Action(FlightSqlUtils.FLIGHT_SQL_CLOSE_PREPARED_STATEMENT.getType(), Any.pack((Message)FlightSql.ActionClosePreparedStatementRequest.newBuilder().setPreparedStatementHandle(this.preparedStatementResult.getPreparedStatementHandle()).build()).toByteArray());
            Iterator closePreparedStatementResults = this.client.doAction(action, options);
            closePreparedStatementResults.forEachRemaining(result -> {});
            this.clearParameters();
        }

        @Override
        public void close() {
            this.close(new CallOption[0]);
        }

        public boolean isClosed() {
            return this.isClosed;
        }
    }
}

