/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.driver.jdbc.shaded.com.google.common.base.Strings;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.ArrowType;

public class SqlTypes {
    private static final Map<Integer, String> typeIdToName = new HashMap<Integer, String>();

    public static String getSqlTypeNameFromArrowType(ArrowType arrowType) {
        int typeId = SqlTypes.getSqlTypeIdFromArrowType(arrowType);
        return typeIdToName.get(typeId);
    }

    public static int getSqlTypeIdFromArrowType(ArrowType arrowType) {
        ArrowType.ArrowTypeID typeID = arrowType.getTypeID();
        switch (typeID) {
            case Int: {
                int bitWidth = ((ArrowType.Int)arrowType).getBitWidth();
                switch (bitWidth) {
                    case 8: {
                        return -6;
                    }
                    case 16: {
                        return 5;
                    }
                    case 32: {
                        return 4;
                    }
                    case 64: {
                        return -5;
                    }
                }
                break;
            }
            case Binary: {
                return -3;
            }
            case FixedSizeBinary: {
                return -2;
            }
            case LargeBinary: {
                return -4;
            }
            case Utf8: {
                return 12;
            }
            case LargeUtf8: {
                return -1;
            }
            case Date: {
                return 91;
            }
            case Time: {
                return 92;
            }
            case Timestamp: {
                String tz = ((ArrowType.Timestamp)arrowType).getTimezone();
                if (Strings.isNullOrEmpty(tz)) {
                    return 93;
                }
                return 2014;
            }
            case Bool: {
                return 16;
            }
            case Decimal: {
                return 3;
            }
            case FloatingPoint: {
                FloatingPointPrecision floatingPointPrecision = ((ArrowType.FloatingPoint)arrowType).getPrecision();
                switch (floatingPointPrecision) {
                    case DOUBLE: {
                        return 8;
                    }
                    case SINGLE: {
                        return 6;
                    }
                }
                break;
            }
            case List: 
            case FixedSizeList: 
            case LargeList: {
                return 2003;
            }
            case Struct: 
            case Duration: 
            case Interval: 
            case Map: 
            case Union: {
                return 2000;
            }
            case NONE: 
            case Null: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Unsupported ArrowType " + String.valueOf(arrowType));
    }

    static {
        typeIdToName.put(-7, "BIT");
        typeIdToName.put(-6, "TINYINT");
        typeIdToName.put(5, "SMALLINT");
        typeIdToName.put(4, "INTEGER");
        typeIdToName.put(-5, "BIGINT");
        typeIdToName.put(6, "FLOAT");
        typeIdToName.put(7, "REAL");
        typeIdToName.put(8, "DOUBLE");
        typeIdToName.put(2, "NUMERIC");
        typeIdToName.put(3, "DECIMAL");
        typeIdToName.put(1, "CHAR");
        typeIdToName.put(12, "VARCHAR");
        typeIdToName.put(-1, "LONGVARCHAR");
        typeIdToName.put(91, "DATE");
        typeIdToName.put(92, "TIME");
        typeIdToName.put(93, "TIMESTAMP");
        typeIdToName.put(-2, "BINARY");
        typeIdToName.put(-3, "VARBINARY");
        typeIdToName.put(-4, "LONGVARBINARY");
        typeIdToName.put(0, "NULL");
        typeIdToName.put(1111, "OTHER");
        typeIdToName.put(2000, "JAVA_OBJECT");
        typeIdToName.put(2001, "DISTINCT");
        typeIdToName.put(2002, "STRUCT");
        typeIdToName.put(2003, "ARRAY");
        typeIdToName.put(2004, "BLOB");
        typeIdToName.put(2005, "CLOB");
        typeIdToName.put(2006, "REF");
        typeIdToName.put(70, "DATALINK");
        typeIdToName.put(16, "BOOLEAN");
        typeIdToName.put(-8, "ROWID");
        typeIdToName.put(-15, "NCHAR");
        typeIdToName.put(-9, "NVARCHAR");
        typeIdToName.put(-16, "LONGNVARCHAR");
        typeIdToName.put(2011, "NCLOB");
        typeIdToName.put(2009, "SQLXML");
        typeIdToName.put(2012, "REF_CURSOR");
        typeIdToName.put(2013, "TIME_WITH_TIMEZONE");
        typeIdToName.put(2014, "TIMESTAMP_WITH_TIMEZONE");
    }
}

