/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static long applyCalendarOffset(long milliseconds, Calendar calendar) {
        TimeZone defaultTz;
        TimeZone tz;
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        if ((tz = calendar.getTimeZone()) != (defaultTz = TimeZone.getDefault())) {
            milliseconds -= (long)(tz.getOffset(milliseconds) - defaultTz.getOffset(milliseconds));
        }
        return milliseconds;
    }

    public static Timestamp getTimestampValue(long millisWithCalendar) {
        long milliseconds = millisWithCalendar;
        if (milliseconds < 0L) {
            milliseconds -= (milliseconds / 86400000L - 1L) * 86400000L;
        }
        return Timestamp.valueOf(LocalDateTime.of(LocalDate.ofEpochDay(millisWithCalendar / 86400000L), LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(milliseconds % 86400000L))));
    }
}

