/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.crypto.mlkem;

import java.security.SecureRandom;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.crypto.mlkem.MLKEMEngine;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;

public class MLKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public MLKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        MLKEMPublicKeyParameters mLKEMPublicKeyParameters = (MLKEMPublicKeyParameters)asymmetricKeyParameter;
        MLKEMEngine mLKEMEngine = mLKEMPublicKeyParameters.getParameters().getEngine();
        mLKEMEngine.init(this.sr);
        byte[] byArray = new byte[32];
        mLKEMEngine.getRandomBytes(byArray);
        byte[][] byArray2 = mLKEMEngine.kemEncrypt(mLKEMPublicKeyParameters.getEncoded(), byArray);
        return new SecretWithEncapsulationImpl(byArray2[0], byArray2[1]);
    }

    public SecretWithEncapsulation internalGenerateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) {
        MLKEMPublicKeyParameters mLKEMPublicKeyParameters = (MLKEMPublicKeyParameters)asymmetricKeyParameter;
        MLKEMEngine mLKEMEngine = mLKEMPublicKeyParameters.getParameters().getEngine();
        mLKEMEngine.init(this.sr);
        byte[][] byArray2 = mLKEMEngine.kemEncryptInternal(mLKEMPublicKeyParameters.getEncoded(), byArray);
        return new SecretWithEncapsulationImpl(byArray2[0], byArray2[1]);
    }
}

