/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.stream.IntStream;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.ProtocolMessageEnum;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql.FlightSqlProducer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql.impl.FlightSql;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.sql.util.SqlInfoOptionsUtils;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.DenseUnionVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.impl.UnionMapWriter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableVarCharHolder;

public class SqlInfoBuilder {
    private final Map<Integer, ObjIntConsumer<VectorSchemaRoot>> providers = new HashMap<Integer, ObjIntConsumer<VectorSchemaRoot>>();

    public static NullableVarCharHolder getHolderForUtf8(String string, ArrowBuf buf) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        buf.setBytes(0L, bytes);
        NullableVarCharHolder holder = new NullableVarCharHolder();
        holder.buffer = buf;
        holder.end = bytes.length;
        holder.isSet = 1;
        return holder;
    }

    public SqlInfoBuilder withFlightSqlServerName(String value) {
        return this.withStringProvider(0, value);
    }

    public SqlInfoBuilder withFlightSqlServerVersion(String value) {
        return this.withStringProvider(1, value);
    }

    public SqlInfoBuilder withFlightSqlServerArrowVersion(String value) {
        return this.withStringProvider(2, value);
    }

    public SqlInfoBuilder withFlightSqlServerSql(boolean value) {
        return this.withBooleanProvider(4, value);
    }

    public SqlInfoBuilder withFlightSqlServerSubstrait(boolean value) {
        return this.withBooleanProvider(5, value);
    }

    public SqlInfoBuilder withFlightSqlServerSubstraitMinVersion(String value) {
        return this.withStringProvider(6, value);
    }

    public SqlInfoBuilder withFlightSqlServerSubstraitMaxVersion(String value) {
        return this.withStringProvider(7, value);
    }

    public SqlInfoBuilder withFlightSqlServerTransaction(FlightSql.SqlSupportedTransaction value) {
        return this.withIntProvider(8, value.getNumber());
    }

    public SqlInfoBuilder withFlightSqlServerCancel(boolean value) {
        return this.withBooleanProvider(9, value);
    }

    public SqlInfoBuilder withFlightSqlServerBulkIngestion(boolean value) {
        return this.withBooleanProvider(10, value);
    }

    public SqlInfoBuilder withFlightSqlServerBulkIngestionTransaction(boolean value) {
        return this.withBooleanProvider(11, value);
    }

    public SqlInfoBuilder withFlightSqlServerStatementTimeout(int value) {
        return this.withIntProvider(100, value);
    }

    public SqlInfoBuilder withFlightSqlServerTransactionTimeout(int value) {
        return this.withIntProvider(101, value);
    }

    public SqlInfoBuilder withSqlIdentifierQuoteChar(String value) {
        return this.withStringProvider(504, value);
    }

    public SqlInfoBuilder withSqlSearchStringEscape(String value) {
        return this.withStringProvider(513, value);
    }

    public SqlInfoBuilder withSqlExtraNameCharacters(String value) {
        return this.withStringProvider(514, value);
    }

    public SqlInfoBuilder withSqlSchemaTerm(String value) {
        return this.withStringProvider(529, value);
    }

    public SqlInfoBuilder withSqlCatalogTerm(String value) {
        return this.withStringProvider(531, value);
    }

    public SqlInfoBuilder withSqlProcedureTerm(String value) {
        return this.withStringProvider(530, value);
    }

    public SqlInfoBuilder withSqlDdlCatalog(boolean value) {
        return this.withBooleanProvider(500, value);
    }

    public SqlInfoBuilder withSqlDdlSchema(boolean value) {
        return this.withBooleanProvider(501, value);
    }

    public SqlInfoBuilder withSqlDdlTable(boolean value) {
        return this.withBooleanProvider(502, value);
    }

    public SqlInfoBuilder withFlightSqlServerReadOnly(boolean value) {
        return this.withBooleanProvider(3, value);
    }

    public SqlInfoBuilder withSqlSupportsColumnAliasing(boolean value) {
        return this.withBooleanProvider(515, value);
    }

    public SqlInfoBuilder withSqlNullPlusNullIsNull(boolean value) {
        return this.withBooleanProvider(516, value);
    }

    public SqlInfoBuilder withSqlSupportsTableCorrelationNames(boolean value) {
        return this.withBooleanProvider(518, value);
    }

    public SqlInfoBuilder withSqlSupportsDifferentTableCorrelationNames(boolean value) {
        return this.withBooleanProvider(519, value);
    }

    public SqlInfoBuilder withSqlSupportsExpressionsInOrderBy(boolean value) {
        return this.withBooleanProvider(520, value);
    }

    public SqlInfoBuilder withSqlSupportsOrderByUnrelated(boolean value) {
        return this.withBooleanProvider(521, value);
    }

    public SqlInfoBuilder withSqlSupportsLikeEscapeClause(boolean value) {
        return this.withBooleanProvider(523, value);
    }

    public SqlInfoBuilder withSqlSupportsNonNullableColumns(boolean value) {
        return this.withBooleanProvider(524, value);
    }

    public SqlInfoBuilder withSqlSupportsIntegrityEnhancementFacility(boolean value) {
        return this.withBooleanProvider(527, value);
    }

    public SqlInfoBuilder withSqlCatalogAtStart(boolean value) {
        return this.withBooleanProvider(532, value);
    }

    public SqlInfoBuilder withSqlSelectForUpdateSupported(boolean value) {
        return this.withBooleanProvider(536, value);
    }

    public SqlInfoBuilder withSqlStoredProceduresSupported(boolean value) {
        return this.withBooleanProvider(537, value);
    }

    public SqlInfoBuilder withSqlCorrelatedSubqueriesSupported(boolean value) {
        return this.withBooleanProvider(539, value);
    }

    public SqlInfoBuilder withSqlMaxRowSizeIncludesBlobs(boolean value) {
        return this.withBooleanProvider(556, value);
    }

    public SqlInfoBuilder withSqlTransactionsSupported(boolean value) {
        return this.withBooleanProvider(563, value);
    }

    public SqlInfoBuilder withSqlDataDefinitionCausesTransactionCommit(boolean value) {
        return this.withBooleanProvider(565, value);
    }

    public SqlInfoBuilder withSqlDataDefinitionsInTransactionsIgnored(boolean value) {
        return this.withBooleanProvider(566, value);
    }

    public SqlInfoBuilder withSqlBatchUpdatesSupported(boolean value) {
        return this.withBooleanProvider(572, value);
    }

    public SqlInfoBuilder withSqlSavepointsSupported(boolean value) {
        return this.withBooleanProvider(573, value);
    }

    public SqlInfoBuilder withSqlNamedParametersSupported(boolean value) {
        return this.withBooleanProvider(574, value);
    }

    public SqlInfoBuilder withSqlLocatorsUpdateCopy(boolean value) {
        return this.withBooleanProvider(575, value);
    }

    public SqlInfoBuilder withSqlStoredFunctionsUsingCallSyntaxSupported(boolean value) {
        return this.withBooleanProvider(576, value);
    }

    public SqlInfoBuilder withSqlIdentifierCase(FlightSql.SqlSupportedCaseSensitivity value) {
        return this.withBitIntProvider(503, value.getNumber());
    }

    public SqlInfoBuilder withSqlQuotedIdentifierCase(FlightSql.SqlSupportedCaseSensitivity value) {
        return this.withBitIntProvider(505, value.getNumber());
    }

    public SqlInfoBuilder withSqlAllTablesAreSelectable(boolean value) {
        return this.withBooleanProvider(506, value);
    }

    public SqlInfoBuilder withSqlNullOrdering(FlightSql.SqlNullOrdering value) {
        return this.withBitIntProvider(507, value.getNumber());
    }

    public SqlInfoBuilder withSqlMaxBinaryLiteralLength(long value) {
        return this.withBitIntProvider(541, value);
    }

    public SqlInfoBuilder withSqlMaxCharLiteralLength(long value) {
        return this.withBitIntProvider(542, value);
    }

    public SqlInfoBuilder withSqlMaxColumnNameLength(long value) {
        return this.withBitIntProvider(543, value);
    }

    public SqlInfoBuilder withSqlMaxColumnsInGroupBy(long value) {
        return this.withBitIntProvider(544, value);
    }

    public SqlInfoBuilder withSqlMaxColumnsInIndex(long value) {
        return this.withBitIntProvider(545, value);
    }

    public SqlInfoBuilder withSqlMaxColumnsInOrderBy(long value) {
        return this.withBitIntProvider(546, value);
    }

    public SqlInfoBuilder withSqlMaxColumnsInSelect(long value) {
        return this.withBitIntProvider(547, value);
    }

    public SqlInfoBuilder withSqlMaxColumnsInTable(long value) {
        return this.withBitIntProvider(548, value);
    }

    public SqlInfoBuilder withSqlMaxConnections(long value) {
        return this.withBitIntProvider(549, value);
    }

    public SqlInfoBuilder withSqlMaxCursorNameLength(long value) {
        return this.withBitIntProvider(550, value);
    }

    public SqlInfoBuilder withSqlMaxIndexLength(long value) {
        return this.withBitIntProvider(551, value);
    }

    public SqlInfoBuilder withSqlDbSchemaNameLength(long value) {
        return this.withBitIntProvider(552, value);
    }

    public SqlInfoBuilder withSqlMaxProcedureNameLength(long value) {
        return this.withBitIntProvider(553, value);
    }

    public SqlInfoBuilder withSqlMaxCatalogNameLength(long value) {
        return this.withBitIntProvider(554, value);
    }

    public SqlInfoBuilder withSqlMaxRowSize(long value) {
        return this.withBitIntProvider(555, value);
    }

    public SqlInfoBuilder withSqlMaxStatementLength(long value) {
        return this.withBitIntProvider(557, value);
    }

    public SqlInfoBuilder withSqlMaxStatements(long value) {
        return this.withBitIntProvider(558, value);
    }

    public SqlInfoBuilder withSqlMaxTableNameLength(long value) {
        return this.withBitIntProvider(559, value);
    }

    public SqlInfoBuilder withSqlMaxTablesInSelect(long value) {
        return this.withBitIntProvider(560, value);
    }

    public SqlInfoBuilder withSqlMaxUsernameLength(long value) {
        return this.withBitIntProvider(561, value);
    }

    public SqlInfoBuilder withSqlDefaultTransactionIsolation(long value) {
        return this.withBitIntProvider(562, value);
    }

    public SqlInfoBuilder withSqlSupportedGroupBy(FlightSql.SqlSupportedGroupBy ... values) {
        return this.withEnumProvider(522, values);
    }

    public SqlInfoBuilder withSqlSupportedGrammar(FlightSql.SupportedSqlGrammar ... values) {
        return this.withEnumProvider(525, values);
    }

    public SqlInfoBuilder withSqlAnsi92SupportedLevel(FlightSql.SupportedAnsi92SqlGrammarLevel ... values) {
        return this.withEnumProvider(526, values);
    }

    public SqlInfoBuilder withSqlSchemasSupportedActions(FlightSql.SqlSupportedElementActions ... values) {
        return this.withEnumProvider(533, values);
    }

    public SqlInfoBuilder withSqlCatalogsSupportedActions(FlightSql.SqlSupportedElementActions ... values) {
        return this.withEnumProvider(534, values);
    }

    public SqlInfoBuilder withSqlSupportedPositionedCommands(FlightSql.SqlSupportedPositionedCommands ... values) {
        return this.withEnumProvider(535, values);
    }

    public SqlInfoBuilder withSqlSubQueriesSupported(FlightSql.SqlSupportedSubqueries ... values) {
        return this.withEnumProvider(538, values);
    }

    public SqlInfoBuilder withSqlSupportedUnions(FlightSql.SqlSupportedUnions ... values) {
        return this.withEnumProvider(540, values);
    }

    public SqlInfoBuilder withSqlOuterJoinSupportLevel(FlightSql.SqlOuterJoinsSupportLevel ... value) {
        return this.withEnumProvider(528, value);
    }

    public SqlInfoBuilder withSqlSupportedTransactionsIsolationLevels(FlightSql.SqlTransactionIsolationLevel ... values) {
        return this.withEnumProvider(564, values);
    }

    public SqlInfoBuilder withSqlSupportedResultSetTypes(FlightSql.SqlSupportedResultSetType ... values) {
        return this.withEnumProvider(567, values);
    }

    public SqlInfoBuilder withSqlKeywords(String[] value) {
        return this.withStringArrayProvider(508, value);
    }

    public SqlInfoBuilder withSqlNumericFunctions(String[] value) {
        return this.withStringArrayProvider(509, value);
    }

    public SqlInfoBuilder withSqlStringFunctions(String[] value) {
        return this.withStringArrayProvider(510, value);
    }

    public SqlInfoBuilder withSqlSystemFunctions(String[] value) {
        return this.withStringArrayProvider(511, value);
    }

    public SqlInfoBuilder withSqlDatetimeFunctions(String[] value) {
        return this.withStringArrayProvider(512, value);
    }

    public SqlInfoBuilder withSqlSupportsConvert(Map<Integer, List<Integer>> value) {
        return this.withIntToIntListMapProvider(517, value);
    }

    private void addProvider(int sqlInfo, ObjIntConsumer<VectorSchemaRoot> provider) {
        this.providers.put(sqlInfo, provider);
    }

    private SqlInfoBuilder withEnumProvider(int sqlInfo, ProtocolMessageEnum[] values) {
        return this.withIntProvider(sqlInfo, (int)SqlInfoOptionsUtils.createBitmaskFromEnums(values));
    }

    private SqlInfoBuilder withIntProvider(int sqlInfo, int value) {
        this.addProvider(sqlInfo, (root, index) -> this.setDataForIntField((VectorSchemaRoot)root, index, sqlInfo, value));
        return this;
    }

    private SqlInfoBuilder withBitIntProvider(int sqlInfo, long value) {
        this.addProvider(sqlInfo, (root, index) -> this.setDataForBigIntField((VectorSchemaRoot)root, index, sqlInfo, value));
        return this;
    }

    private SqlInfoBuilder withBooleanProvider(int sqlInfo, boolean value) {
        this.addProvider(sqlInfo, (root, index) -> this.setDataForBooleanField((VectorSchemaRoot)root, index, sqlInfo, value));
        return this;
    }

    private SqlInfoBuilder withStringProvider(int sqlInfo, String value) {
        this.addProvider(sqlInfo, (root, index) -> this.setDataForUtf8Field((VectorSchemaRoot)root, index, sqlInfo, value));
        return this;
    }

    private SqlInfoBuilder withStringArrayProvider(int sqlInfo, String[] value) {
        this.addProvider(sqlInfo, (root, index) -> this.setDataVarCharListField((VectorSchemaRoot)root, index, sqlInfo, value));
        return this;
    }

    private SqlInfoBuilder withIntToIntListMapProvider(int sqlInfo, Map<Integer, List<Integer>> value) {
        this.addProvider(sqlInfo, (root, index) -> this.setIntToIntListMapField((VectorSchemaRoot)root, index, sqlInfo, value));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(List<Integer> infos, FlightProducer.ServerStreamListener listener) {
        if (infos == null || infos.isEmpty()) {
            infos = new ArrayList<Integer>(this.providers.keySet());
        }
        try (RootAllocator allocator = new RootAllocator();
             VectorSchemaRoot root = VectorSchemaRoot.create(FlightSqlProducer.Schemas.GET_SQL_INFO_SCHEMA, allocator);){
            int rows = infos.size();
            for (int i = 0; i < rows; ++i) {
                this.providers.get(infos.get(i)).accept(root, i);
            }
            root.setRowCount(rows);
            listener.start(root);
            listener.putNext();
        }
        catch (Throwable throwable) {
            listener.error(throwable);
        }
        finally {
            listener.completed();
        }
    }

    private void setInfoName(VectorSchemaRoot root, int index, int info) {
        UInt4Vector infoName = (UInt4Vector)root.getVector("info_name");
        infoName.setSafe(index, info);
    }

    private void setValues(VectorSchemaRoot root, int index, byte typeId, Consumer<DenseUnionVector> dataSetter) {
        DenseUnionVector values = (DenseUnionVector)root.getVector("value");
        values.setTypeId(index, typeId);
        dataSetter.accept(values);
    }

    private void onCreateArrowBuf(Consumer<ArrowBuf> executor) {
        try (RootAllocator allocator = new RootAllocator();
             ArrowBuf buf = allocator.buffer(1024L);){
            executor.accept(buf);
        }
    }

    private void setDataForUtf8Field(VectorSchemaRoot root, int index, int sqlInfo, String value) {
        this.setInfoName(root, index, sqlInfo);
        this.onCreateArrowBuf(buf -> {
            Consumer<DenseUnionVector> producer = values -> values.setSafe(index, SqlInfoBuilder.getHolderForUtf8(value, buf));
            this.setValues(root, index, (byte)0, producer);
        });
    }

    private void setDataForIntField(VectorSchemaRoot root, int index, int sqlInfo, int value) {
        this.setInfoName(root, index, sqlInfo);
        NullableIntHolder dataHolder = new NullableIntHolder();
        dataHolder.isSet = 1;
        dataHolder.value = value;
        this.setValues(root, index, (byte)3, values -> values.setSafe(index, dataHolder));
    }

    private void setDataForBigIntField(VectorSchemaRoot root, int index, int sqlInfo, long value) {
        this.setInfoName(root, index, sqlInfo);
        NullableBigIntHolder dataHolder = new NullableBigIntHolder();
        dataHolder.isSet = 1;
        dataHolder.value = value;
        this.setValues(root, index, (byte)2, values -> values.setSafe(index, dataHolder));
    }

    private void setDataForBooleanField(VectorSchemaRoot root, int index, int sqlInfo, boolean value) {
        this.setInfoName(root, index, sqlInfo);
        NullableBitHolder dataHolder = new NullableBitHolder();
        dataHolder.isSet = 1;
        dataHolder.value = value ? 1 : 0;
        this.setValues(root, index, (byte)1, values -> values.setSafe(index, dataHolder));
    }

    private void setDataVarCharListField(VectorSchemaRoot root, int index, int sqlInfo, String[] values) {
        DenseUnionVector denseUnion = (DenseUnionVector)root.getVector("value");
        ListVector listVector = denseUnion.getList((byte)4);
        int listIndex = listVector.getValueCount();
        int denseUnionValueCount = index + 1;
        int listVectorValueCount = listIndex + 1;
        denseUnion.setValueCount(denseUnionValueCount);
        listVector.setValueCount(listVectorValueCount);
        UnionListWriter writer = listVector.getWriter();
        writer.setPosition(listIndex);
        writer.startList();
        int length = values.length;
        IntStream.range(0, length).forEach(i -> this.onCreateArrowBuf(buf -> {
            byte[] bytes = values[i].getBytes(StandardCharsets.UTF_8);
            buf.setBytes(0L, bytes);
            writer.writeVarChar(0, bytes.length, (ArrowBuf)buf);
        }));
        writer.endList();
        writer.setValueCount(listVectorValueCount);
        denseUnion.setTypeId(index, (byte)4);
        denseUnion.getOffsetBuffer().setInt((long)index * 4L, listIndex);
        this.setInfoName(root, index, sqlInfo);
    }

    private void setIntToIntListMapField(VectorSchemaRoot root, int index, int sqlInfo, Map<Integer, List<Integer>> values) {
        DenseUnionVector denseUnion = (DenseUnionVector)root.getVector("value");
        MapVector mapVector = denseUnion.getMap((byte)5);
        int mapIndex = mapVector.getValueCount();
        denseUnion.setValueCount(index + 1);
        mapVector.setValueCount(mapIndex + 1);
        UnionMapWriter mapWriter = mapVector.getWriter();
        mapWriter.setPosition(mapIndex);
        mapWriter.startMap();
        values.forEach((key, value) -> {
            mapWriter.startEntry();
            mapWriter.key().integer().writeInt((int)key);
            BaseWriter.ListWriter listWriter = mapWriter.value().list();
            listWriter.startList();
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                int v = (Integer)iterator.next();
                listWriter.integer().writeInt(v);
            }
            listWriter.endList();
            mapWriter.endEntry();
        });
        mapWriter.endMap();
        mapWriter.setValueCount(mapIndex + 1);
        denseUnion.setTypeId(index, (byte)5);
        denseUnion.getOffsetBuffer().setInt((long)index * 4L, mapIndex);
        this.setInfoName(root, index, sqlInfo);
    }
}

