/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cmp;

import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Encodable;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Integer;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Object;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1OctetString;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Primitive;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1TaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.ASN1Util;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DERSequence;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.DERTaggedObject;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.cmp.PKIFreeText;
import org.apache.arrow.driver.jdbc.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KemOtherInfo
extends ASN1Object {
    private static final PKIFreeText DEFAULT_staticString = new PKIFreeText("CMP-KEM");
    private final PKIFreeText staticString;
    private final ASN1OctetString transactionID;
    private final ASN1OctetString senderNonce;
    private final ASN1OctetString recipNonce;
    private final ASN1Integer len;
    private final AlgorithmIdentifier mac;
    private final ASN1OctetString ct;

    public KemOtherInfo(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString aSN1OctetString3, ASN1Integer aSN1Integer, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString4) {
        this.staticString = DEFAULT_staticString;
        this.transactionID = aSN1OctetString;
        this.senderNonce = aSN1OctetString2;
        this.recipNonce = aSN1OctetString3;
        this.len = aSN1Integer;
        this.mac = algorithmIdentifier;
        this.ct = aSN1OctetString4;
    }

    public KemOtherInfo(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ASN1OctetString aSN1OctetString3, long l, AlgorithmIdentifier algorithmIdentifier, ASN1OctetString aSN1OctetString4) {
        this(aSN1OctetString, aSN1OctetString2, aSN1OctetString3, new ASN1Integer(l), algorithmIdentifier, aSN1OctetString4);
    }

    private KemOtherInfo(ASN1Sequence aSN1Sequence) {
        ASN1Primitive aSN1Primitive;
        ASN1TaggedObject aSN1TaggedObject;
        if (aSN1Sequence.size() < 4 || aSN1Sequence.size() > 7) {
            throw new IllegalArgumentException("sequence size should be between 4 and 7 inclusive");
        }
        int n = 0;
        this.staticString = PKIFreeText.getInstance(aSN1Sequence.getObjectAt(n));
        if (!DEFAULT_staticString.equals(this.staticString)) {
            throw new IllegalArgumentException("staticString field should be " + DEFAULT_staticString);
        }
        ASN1OctetString aSN1OctetString = null;
        ASN1OctetString aSN1OctetString2 = null;
        ASN1OctetString aSN1OctetString3 = null;
        if ((aSN1TaggedObject = KemOtherInfo.tryGetTagged(aSN1Sequence, ++n)) != null && (aSN1Primitive = ASN1Util.tryGetContextBaseUniversal(aSN1TaggedObject, 0, true, 4)) != null) {
            aSN1OctetString = (ASN1OctetString)aSN1Primitive;
            aSN1TaggedObject = KemOtherInfo.tryGetTagged(aSN1Sequence, ++n);
        }
        if (aSN1TaggedObject != null && (aSN1Primitive = ASN1Util.tryGetContextBaseUniversal(aSN1TaggedObject, 1, true, 4)) != null) {
            aSN1OctetString2 = (ASN1OctetString)aSN1Primitive;
            aSN1TaggedObject = KemOtherInfo.tryGetTagged(aSN1Sequence, ++n);
        }
        if (aSN1TaggedObject != null && (aSN1Primitive = ASN1Util.tryGetContextBaseUniversal(aSN1TaggedObject, 2, true, 4)) != null) {
            aSN1OctetString3 = (ASN1OctetString)aSN1Primitive;
            aSN1TaggedObject = KemOtherInfo.tryGetTagged(aSN1Sequence, ++n);
        }
        if (aSN1TaggedObject != null) {
            throw new IllegalArgumentException("unknown tag: " + ASN1Util.getTagText(aSN1TaggedObject));
        }
        this.transactionID = aSN1OctetString;
        this.senderNonce = aSN1OctetString2;
        this.recipNonce = aSN1OctetString3;
        this.len = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(n));
        this.mac = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(++n));
        this.ct = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(++n));
        if (++n != aSN1Sequence.size()) {
            throw new IllegalArgumentException("unexpected data at end of sequence");
        }
    }

    public static KemOtherInfo getInstance(Object object) {
        if (object instanceof KemOtherInfo) {
            return (KemOtherInfo)object;
        }
        if (object != null) {
            return new KemOtherInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public ASN1OctetString getSenderNonce() {
        return this.senderNonce;
    }

    public ASN1OctetString getRecipNonce() {
        return this.recipNonce;
    }

    public ASN1Integer getLen() {
        return this.len;
    }

    public AlgorithmIdentifier getMac() {
        return this.mac;
    }

    public ASN1OctetString getCt() {
        return this.ct;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(7);
        aSN1EncodableVector.add(this.staticString);
        KemOtherInfo.addOptional(aSN1EncodableVector, 0, this.transactionID);
        KemOtherInfo.addOptional(aSN1EncodableVector, 1, this.senderNonce);
        KemOtherInfo.addOptional(aSN1EncodableVector, 2, this.recipNonce);
        aSN1EncodableVector.add(this.len);
        aSN1EncodableVector.add(this.mac);
        aSN1EncodableVector.add(this.ct);
        return new DERSequence(aSN1EncodableVector);
    }

    private static void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n, aSN1Encodable));
        }
    }

    private static ASN1TaggedObject tryGetTagged(ASN1Sequence aSN1Sequence, int n) {
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(n);
        return aSN1Encodable instanceof ASN1TaggedObject ? (ASN1TaggedObject)aSN1Encodable : null;
    }
}

