/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth;

import java.util.Iterator;
import java.util.Optional;
import org.apache.arrow.driver.jdbc.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

public class BasicServerAuthHandler
implements ServerAuthHandler {
    private static final Logger logger = LoggerFactory.getLogger(BasicServerAuthHandler.class);
    private final BasicAuthValidator authValidator;

    public BasicServerAuthHandler(BasicAuthValidator authValidator) {
        this.authValidator = authValidator;
    }

    @Override
    public boolean authenticate(ServerAuthHandler.ServerAuthSender outgoing, Iterator<byte[]> incoming) {
        byte[] bytes = incoming.next();
        try {
            Flight.BasicAuth auth = Flight.BasicAuth.parseFrom(bytes);
            byte[] token = this.authValidator.getToken(auth.getUsername(), auth.getPassword());
            outgoing.send(token);
            return true;
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug("Failure parsing auth message.", e);
        }
        catch (Exception e) {
            logger.debug("Unknown error during authorization.", e);
        }
        return false;
    }

    @Override
    public Optional<String> isValid(byte[] token) {
        return this.authValidator.isValid(token);
    }

    public static interface BasicAuthValidator {
        public byte[] getToken(String var1, String var2) throws Exception;

        public Optional<String> isValid(byte[] var1);
    }
}

