/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.accessor.impl.numeric;

import java.math.BigDecimal;
import java.util.function.IntSupplier;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessor;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BitVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableBitHolder;

public class ArrowFlightJdbcBitVectorAccessor
extends ArrowFlightJdbcAccessor {
    private final BitVector vector;
    private final NullableBitHolder holder;

    public ArrowFlightJdbcBitVectorAccessor(BitVector vector, IntSupplier currentRowSupplier, ArrowFlightJdbcAccessorFactory.WasNullConsumer setCursorWasNull) {
        super(currentRowSupplier, setCursorWasNull);
        this.vector = vector;
        this.holder = new NullableBitHolder();
    }

    @Override
    public Class<?> getObjectClass() {
        return Boolean.class;
    }

    @Override
    public String getString() {
        boolean value = this.getBoolean();
        return this.wasNull ? null : Boolean.toString(value);
    }

    @Override
    public boolean getBoolean() {
        return this.getLong() != 0L;
    }

    @Override
    public byte getByte() {
        return (byte)this.getLong();
    }

    @Override
    public short getShort() {
        return (short)this.getLong();
    }

    @Override
    public int getInt() {
        return (int)this.getLong();
    }

    @Override
    public long getLong() {
        this.vector.get(this.getCurrentRow(), this.holder);
        this.wasNull = this.holder.isSet == 0;
        this.wasNullConsumer.setWasNull(this.wasNull);
        if (this.wasNull) {
            return 0L;
        }
        return this.holder.value;
    }

    @Override
    public float getFloat() {
        return this.getLong();
    }

    @Override
    public double getDouble() {
        return this.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        long value = this.getLong();
        return this.wasNull ? null : BigDecimal.valueOf(value);
    }

    @Override
    public Object getObject() {
        boolean value = this.getBoolean();
        return this.wasNull ? null : Boolean.valueOf(value);
    }
}

