/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public final class UrlParser {
    private UrlParser() {
    }

    public static Map<String, String> parse(String url, String separator) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (url != null) {
            String[] keyValues;
            for (String keyValue : keyValues = url.split(separator)) {
                try {
                    int separatorKey = keyValue.indexOf("=");
                    if (separatorKey == -1) continue;
                    String key = keyValue.substring(0, separatorKey);
                    key = URLDecoder.decode(key, "UTF-8");
                    String value = "";
                    if (!keyValue.endsWith("=")) {
                        value = keyValue.substring(separatorKey + 1);
                    }
                    value = URLDecoder.decode(value, "UTF-8");
                    resultMap.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return resultMap;
    }
}

