/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.arrow.driver.jdbc.client.CloseableEndpointStreamPair;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

public class FlightEndpointDataQueue
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlightEndpointDataQueue.class);
    private final CompletionService<CloseableEndpointStreamPair> completionService;
    private final Set<Future<CloseableEndpointStreamPair>> futures = Collections.synchronizedSet(new HashSet());
    private final Set<CloseableEndpointStreamPair> endpointsToClose = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean closed = new AtomicBoolean();

    protected FlightEndpointDataQueue(CompletionService<CloseableEndpointStreamPair> executorService) {
        this.completionService = Preconditions.checkNotNull(executorService);
    }

    public static FlightEndpointDataQueue createNewQueue(ExecutorService service) {
        return new FlightEndpointDataQueue(new ExecutorCompletionService<CloseableEndpointStreamPair>(service));
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    private CloseableEndpointStreamPair next(EndpointStreamSupplier endpointStreamSupplier) throws SQLException {
        this.checkOpen();
        while (!this.futures.isEmpty()) {
            Future<CloseableEndpointStreamPair> future = endpointStreamSupplier.get();
            this.futures.remove(future);
            try {
                CloseableEndpointStreamPair endpoint = future.get();
                if (endpoint == null) continue;
                return endpoint;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof FlightRuntimeException) {
                    throw (FlightRuntimeException)cause;
                }
                throw AvaticaConnection.HELPER.wrap(e.getMessage(), e);
            }
            catch (InterruptedException | CancellationException e) {
                throw AvaticaConnection.HELPER.wrap(e.getMessage(), e);
            }
        }
        return null;
    }

    public CloseableEndpointStreamPair next(long timeoutValue, TimeUnit timeoutUnit) throws SQLException {
        return this.next(() -> {
            try {
                Future<CloseableEndpointStreamPair> future = this.completionService.poll(timeoutValue, timeoutUnit);
                if (future != null) {
                    return future;
                }
            }
            catch (InterruptedException e) {
                throw new SQLTimeoutException("Query was interrupted", e);
            }
            throw new SQLTimeoutException(String.format("Query timed out after %d %s", new Object[]{timeoutValue, timeoutUnit}));
        });
    }

    public CloseableEndpointStreamPair next() throws SQLException {
        return this.next(() -> {
            try {
                return this.completionService.take();
            }
            catch (InterruptedException e) {
                throw AvaticaConnection.HELPER.wrap(e.getMessage(), e);
            }
        });
    }

    public synchronized void checkOpen() {
        Preconditions.checkState(!this.isClosed(), String.format("%s closed", this.getClass().getSimpleName()));
    }

    public void enqueue(Collection<CloseableEndpointStreamPair> endpointRequests) {
        endpointRequests.forEach(this::enqueue);
    }

    public synchronized void enqueue(CloseableEndpointStreamPair endpointRequest) {
        Preconditions.checkNotNull(endpointRequest);
        this.checkOpen();
        this.endpointsToClose.add(endpointRequest);
        this.futures.add(this.completionService.submit(() -> {
            while (endpointRequest.getStream().next()) {
                if (endpointRequest.getStream().getRoot().getRowCount() <= 0) continue;
                return endpointRequest;
            }
            return null;
        }));
    }

    private static boolean isCallStatusCancelled(Exception e) {
        return e.getCause() instanceof FlightRuntimeException && ((FlightRuntimeException)e.getCause()).status().code() == CallStatus.CANCELLED.code();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        HashSet<SQLException> exceptions = new HashSet<SQLException>();
        try {
            String errorMsg;
            for (CloseableEndpointStreamPair endpointToClose : this.endpointsToClose) {
                try {
                    endpointToClose.getStream().cancel("Cancelling this FlightStream.", null);
                }
                catch (Exception e) {
                    errorMsg = "Failed to cancel a FlightStream.";
                    LOGGER.error("Failed to cancel a FlightStream.", e);
                    exceptions.add(new SQLException("Failed to cancel a FlightStream.", e));
                }
            }
            this.futures.forEach(future -> {
                block2: {
                    try {
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        if (FlightEndpointDataQueue.isCallStatusCancelled(e)) break block2;
                        String errorMsg = "Failed consuming a future during close.";
                        LOGGER.error("Failed consuming a future during close.", e);
                        exceptions.add(new SQLException("Failed consuming a future during close.", e));
                    }
                }
            });
            for (CloseableEndpointStreamPair endpointToClose : this.endpointsToClose) {
                try {
                    endpointToClose.close();
                }
                catch (Exception e) {
                    errorMsg = "Failed to close a FlightStream.";
                    LOGGER.error("Failed to close a FlightStream.", e);
                    exceptions.add(new SQLException("Failed to close a FlightStream.", e));
                }
            }
        }
        finally {
            this.endpointsToClose.clear();
            this.futures.clear();
            this.closed.set(true);
        }
        if (!exceptions.isEmpty()) {
            SQLException sqlException = new SQLException("Failed to close streams.");
            exceptions.forEach(sqlException::setNextException);
            throw sqlException;
        }
    }

    @FunctionalInterface
    static interface EndpointStreamSupplier {
        public Future<CloseableEndpointStreamPair> get() throws SQLException;
    }
}

