/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightCallHeaders;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.HeaderCallOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ConnectionConfigImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ConnectionProperty;

public final class ArrowFlightConnectionConfigImpl
extends ConnectionConfigImpl {
    public ArrowFlightConnectionConfigImpl(Properties properties) {
        super(properties);
    }

    public String getHost() {
        return ArrowFlightConnectionProperty.HOST.getString(this.properties);
    }

    public int getPort() {
        return ArrowFlightConnectionProperty.PORT.getInteger(this.properties);
    }

    public String getUser() {
        return ArrowFlightConnectionProperty.USER.getString(this.properties);
    }

    public String getPassword() {
        return ArrowFlightConnectionProperty.PASSWORD.getString(this.properties);
    }

    public String getToken() {
        return ArrowFlightConnectionProperty.TOKEN.getString(this.properties);
    }

    public String getTrustStorePath() {
        return ArrowFlightConnectionProperty.TRUST_STORE.getString(this.properties);
    }

    public String getTrustStorePassword() {
        return ArrowFlightConnectionProperty.TRUST_STORE_PASSWORD.getString(this.properties);
    }

    public boolean useSystemTrustStore() {
        return ArrowFlightConnectionProperty.USE_SYSTEM_TRUST_STORE.getBoolean(this.properties);
    }

    public String getTlsRootCertificatesPath() {
        return ArrowFlightConnectionProperty.TLS_ROOT_CERTS.getString(this.properties);
    }

    public String getClientCertificatePath() {
        return ArrowFlightConnectionProperty.CLIENT_CERTIFICATE.getString(this.properties);
    }

    public String getClientKeyPath() {
        return ArrowFlightConnectionProperty.CLIENT_KEY.getString(this.properties);
    }

    public boolean useEncryption() {
        return ArrowFlightConnectionProperty.USE_ENCRYPTION.getBoolean(this.properties);
    }

    public boolean getDisableCertificateVerification() {
        return ArrowFlightConnectionProperty.CERTIFICATE_VERIFICATION.getBoolean(this.properties);
    }

    public int threadPoolSize() {
        return ArrowFlightConnectionProperty.THREAD_POOL_SIZE.getInteger(this.properties);
    }

    public boolean retainCookies() {
        return ArrowFlightConnectionProperty.RETAIN_COOKIES.getBoolean(this.properties);
    }

    public boolean retainAuth() {
        return ArrowFlightConnectionProperty.RETAIN_AUTH.getBoolean(this.properties);
    }

    public String getCatalog() {
        return ArrowFlightConnectionProperty.CATALOG.getString(this.properties);
    }

    public CallOption toCallOption() {
        FlightCallHeaders headers = new FlightCallHeaders();
        Map<String, String> headerAttributes = this.getHeaderAttributes();
        headerAttributes.forEach(headers::insert);
        return new HeaderCallOption(headers);
    }

    public Map<String, String> getHeaderAttributes() {
        HashMap<String, String> headers = new HashMap<String, String>();
        ArrowFlightConnectionProperty[] builtInProperties = ArrowFlightConnectionProperty.values();
        this.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> {
            if (Arrays.stream(builtInProperties).noneMatch(builtInProperty -> builtInProperty.camelName.equalsIgnoreCase(key.toString()))) {
                headers.put(key.toString(), val.toString());
            }
        }));
        return headers;
    }

    public static enum ArrowFlightConnectionProperty implements ConnectionProperty
    {
        HOST("host", null, ConnectionProperty.Type.STRING, true),
        PORT("port", null, ConnectionProperty.Type.NUMBER, true),
        USER("user", null, ConnectionProperty.Type.STRING, false),
        PASSWORD("password", null, ConnectionProperty.Type.STRING, false),
        USE_ENCRYPTION("useEncryption", true, ConnectionProperty.Type.BOOLEAN, false),
        CERTIFICATE_VERIFICATION("disableCertificateVerification", false, ConnectionProperty.Type.BOOLEAN, false),
        TRUST_STORE("trustStore", null, ConnectionProperty.Type.STRING, false),
        TRUST_STORE_PASSWORD("trustStorePassword", null, ConnectionProperty.Type.STRING, false),
        USE_SYSTEM_TRUST_STORE("useSystemTrustStore", true, ConnectionProperty.Type.BOOLEAN, false),
        TLS_ROOT_CERTS("tlsRootCerts", null, ConnectionProperty.Type.STRING, false),
        CLIENT_CERTIFICATE("clientCertificate", null, ConnectionProperty.Type.STRING, false),
        CLIENT_KEY("clientKey", null, ConnectionProperty.Type.STRING, false),
        THREAD_POOL_SIZE("threadPoolSize", 1, ConnectionProperty.Type.NUMBER, false),
        TOKEN("token", null, ConnectionProperty.Type.STRING, false),
        RETAIN_COOKIES("retainCookies", true, ConnectionProperty.Type.BOOLEAN, false),
        RETAIN_AUTH("retainAuth", true, ConnectionProperty.Type.BOOLEAN, false),
        CATALOG("catalog", null, ConnectionProperty.Type.STRING, false);

        private final String camelName;
        private final Object defaultValue;
        private final ConnectionProperty.Type type;
        private final boolean required;

        private ArrowFlightConnectionProperty(String camelName, Object defaultValue, ConnectionProperty.Type type, boolean required) {
            this.camelName = Preconditions.checkNotNull(camelName);
            this.defaultValue = defaultValue;
            this.type = Preconditions.checkNotNull(type);
            this.required = required;
        }

        public Object get(Properties properties) {
            Preconditions.checkNotNull(properties, "Properties cannot be null.");
            Object value = properties.get(this.camelName);
            if (value == null) {
                value = properties.get(this.camelName.toLowerCase());
            }
            if (this.required) {
                if (value == null) {
                    throw new IllegalStateException(String.format("Required property not provided: <%s>.", this));
                }
                return value;
            }
            return value != null ? value : this.defaultValue;
        }

        public Boolean getBoolean(Properties properties) {
            String valueFromProperties = String.valueOf(this.get(properties));
            return valueFromProperties.equals("1") || valueFromProperties.equals("true");
        }

        public Integer getInteger(Properties properties) {
            String valueFromProperties = String.valueOf(this.get(properties));
            return valueFromProperties.equals("null") ? null : Integer.valueOf(Integer.parseInt(valueFromProperties));
        }

        public String getString(Properties properties) {
            return Objects.toString(this.get(properties), null);
        }

        @Override
        public String camelName() {
            return this.camelName;
        }

        @Override
        public Object defaultValue() {
            return this.defaultValue;
        }

        @Override
        public ConnectionProperty.Type type() {
            return this.type;
        }

        @Override
        public ConnectionConfigImpl.PropEnv wrap(Properties properties) {
            throw new UnsupportedOperationException("Operation unsupported.");
        }

        @Override
        public boolean required() {
            return this.required;
        }

        @Override
        public Class<?> valueClass() {
            return this.type.defaultValueClass();
        }

        public static String replaceSemiColons(String url) {
            if (url != null) {
                url = url.replaceFirst(";", "?");
                url = url.replaceAll(";", "&");
            }
            return url;
        }
    }
}

