/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote;

import java.io.IOException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.metrics.Timer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.AbstractHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.Handler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.MetricsHelper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.Service;

public class ProtobufHandler
extends AbstractHandler<byte[]> {
    private final ProtobufTranslation translation;
    private final MetricsSystem metrics;
    private final Timer serializationTimer;

    public ProtobufHandler(Service service, ProtobufTranslation translation, MetricsSystem metrics) {
        super(service);
        this.translation = translation;
        this.metrics = metrics;
        this.serializationTimer = this.metrics.getTimer(MetricsHelper.concat(ProtobufHandler.class, "Handler.Serialization"));
    }

    @Override
    public Handler.HandlerResponse<byte[]> apply(byte[] requestBytes) {
        return super.apply(requestBytes);
    }

    @Override
    Service.Request decode(byte[] serializedRequest) throws IOException {
        try (Timer.Context ctx = this.serializationTimer.start();){
            Service.Request request = this.translation.parseRequest(serializedRequest);
            return request;
        }
    }

    @Override
    byte[] encode(Service.Response response) throws IOException {
        try (Timer.Context ctx = this.serializationTimer.start();){
            byte[] byArray = this.translation.serializeResponse(response);
            return byArray;
        }
    }
}

