/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote;

import java.io.IOException;
import java.io.StringWriter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.metrics.MetricsSystem;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.metrics.Timer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.AbstractHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.Handler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.JsonService;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.MetricsHelper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.remote.Service;

public class JsonHandler
extends AbstractHandler<String> {
    protected static final ObjectMapper MAPPER = JsonService.MAPPER;
    final MetricsSystem metrics;
    final Timer serializationTimer;

    public JsonHandler(Service service, MetricsSystem metrics) {
        super(service);
        this.metrics = metrics;
        this.serializationTimer = this.metrics.getTimer(MetricsHelper.concat(JsonHandler.class, "Handler.Serialization"));
    }

    @Override
    public Handler.HandlerResponse<String> apply(String jsonRequest) {
        return super.apply(jsonRequest);
    }

    @Override
    Service.Request decode(String request) throws IOException {
        try (Timer.Context ctx = this.serializationTimer.start();){
            Service.Request request2 = MAPPER.readValue(request, Service.Request.class);
            return request2;
        }
    }

    @Override
    String encode(Service.Response response) throws IOException {
        try (Timer.Context ctx = this.serializationTimer.start();){
            StringWriter w = new StringWriter();
            MAPPER.writeValue(w, (Object)response);
            String string = w.toString();
            return string;
        }
    }
}

