/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.AbstractContainerVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.UnionVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.VectorWithOrdinal;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.CallBack;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.PromotableMultiMapWithOrdinal;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.ValueVectorUtility;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

public abstract class AbstractStructVector
extends AbstractContainerVector {
    private static final Logger logger;
    private static final String STRUCT_CONFLICT_POLICY_ENV = "ARROW_STRUCT_CONFLICT_POLICY";
    private static final String STRUCT_CONFLICT_POLICY_JVM = "arrow.struct.conflict.policy";
    private static final ConflictPolicy DEFAULT_CONFLICT_POLICY;
    private final PromotableMultiMapWithOrdinal<String, FieldVector> vectors;
    protected final boolean allowConflictPolicyChanges;
    private ConflictPolicy conflictPolicy;

    protected AbstractStructVector(String name, BufferAllocator allocator, CallBack callBack, ConflictPolicy conflictPolicy, boolean allowConflictPolicyChanges) {
        super(name, allocator, callBack);
        this.conflictPolicy = conflictPolicy == null ? DEFAULT_CONFLICT_POLICY : conflictPolicy;
        this.vectors = new PromotableMultiMapWithOrdinal(allowConflictPolicyChanges, this.conflictPolicy);
        this.allowConflictPolicyChanges = allowConflictPolicyChanges;
    }

    public ConflictPolicy setConflictPolicy(ConflictPolicy conflictPolicy) {
        ConflictPolicy tmp = this.conflictPolicy;
        this.conflictPolicy = conflictPolicy;
        this.vectors.setConflictPolicy(conflictPolicy);
        return tmp;
    }

    public ConflictPolicy getConflictPolicy() {
        return this.conflictPolicy;
    }

    @Override
    public void close() {
        for (ValueVector valueVector : this.vectors.values()) {
            valueVector.close();
        }
        this.vectors.clear();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            for (ValueVector valueVector : this.vectors.values()) {
                if (valueVector.allocateNewSafe()) continue;
                boolean bl = false;
                return bl;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        return true;
    }

    @Override
    public void reAlloc() {
        for (ValueVector valueVector : this.vectors.values()) {
            valueVector.reAlloc();
        }
    }

    @Override
    public <T extends FieldVector> T addOrGet(String childName, FieldType fieldType, Class<T> clazz) {
        FieldVector existing = this.getChild(childName);
        boolean create = false;
        if (existing == null) {
            create = true;
        } else {
            if (clazz.isAssignableFrom(existing.getClass())) {
                return (T)((FieldVector)clazz.cast(existing));
            }
            if (this.nullFilled(existing)) {
                existing.clear();
                create = true;
            }
        }
        if (create) {
            FieldVector vector = (FieldVector)clazz.cast(fieldType.createNewSingleVector(childName, this.allocator, this.callBack));
            this.putChild(childName, vector);
            if (this.callBack != null) {
                this.callBack.doWork();
            }
            return (T)vector;
        }
        String message = "Arrow does not support schema change yet. Existing[%s] and desired[%s] vector types mismatch";
        throw new IllegalStateException(String.format("Arrow does not support schema change yet. Existing[%s] and desired[%s] vector types mismatch", existing.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    private boolean nullFilled(ValueVector vector) {
        return BitVectorHelper.checkAllBitsEqualTo(vector.getValidityBuffer(), vector.getValueCount(), false);
    }

    public ValueVector getChildByOrdinal(int id) {
        return this.vectors.getByOrdinal(id);
    }

    @Override
    public <T extends FieldVector> T getChild(String name, Class<T> clazz) {
        FieldVector f = this.vectors.get(name);
        if (f == null) {
            return null;
        }
        return (T)((FieldVector)this.typeify(f, clazz));
    }

    protected ValueVector add(String childName, FieldType fieldType) {
        FieldVector vector = fieldType.createNewSingleVector(childName, this.allocator, this.callBack);
        this.putChild(childName, vector);
        if (this.callBack != null) {
            this.callBack.doWork();
        }
        return vector;
    }

    protected void putChild(String name, FieldVector vector) {
        this.putVector(name, vector);
    }

    private void put(String name, FieldVector vector, boolean overwrite) {
        boolean old = this.vectors.put(Preconditions.checkNotNull(name, "field name cannot be null"), Preconditions.checkNotNull(vector, "vector cannot be null"), overwrite);
        if (old) {
            logger.debug("Field [{}] mutated to [{}] ", (Object)name, (Object)vector.getClass().getSimpleName());
        }
    }

    protected void putVector(String name, FieldVector vector) {
        switch (this.conflictPolicy.ordinal()) {
            case 0: {
                this.put(name, vector, false);
                break;
            }
            case 1: {
                if (this.vectors.containsKey(name)) break;
                this.put(name, vector, false);
                break;
            }
            case 2: {
                if (this.vectors.containsKey(name)) {
                    this.vectors.removeAll(name);
                }
                this.put(name, vector, true);
                break;
            }
            case 3: {
                if (this.vectors.containsKey(name)) {
                    throw new IllegalStateException(String.format("Vector already exists: Existing[%s], Requested[%s] ", vector.getClass().getSimpleName(), vector.getField().getFieldType()));
                }
                this.put(name, vector, false);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("%s type not a valid conflict state", new Object[]{this.conflictPolicy}));
            }
        }
    }

    protected List<FieldVector> getChildren() {
        int size = this.vectors.size();
        ArrayList<FieldVector> children = new ArrayList<FieldVector>();
        for (int i = 0; i < size; ++i) {
            children.add(this.vectors.getByOrdinal(i));
        }
        return children;
    }

    public List<String> getChildFieldNames() {
        return this.getChildren().stream().map(child -> child.getField().getName()).collect(Collectors.toList());
    }

    @Override
    public int size() {
        return this.vectors.size();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.unmodifiableCollection(this.vectors.values()).iterator();
    }

    public List<ValueVector> getPrimitiveVectors() {
        ArrayList<ValueVector> primitiveVectors = new ArrayList<ValueVector>();
        for (FieldVector v : this.vectors.values()) {
            primitiveVectors.addAll(this.getPrimitiveVectors(v));
        }
        return primitiveVectors;
    }

    private List<ValueVector> getPrimitiveVectors(FieldVector v) {
        ArrayList<ValueVector> primitives = new ArrayList<ValueVector>();
        if (v instanceof AbstractStructVector) {
            AbstractStructVector structVector = (AbstractStructVector)((Object)v);
            primitives.addAll(structVector.getPrimitiveVectors());
        } else if (v instanceof ListVector) {
            ListVector listVector = (ListVector)v;
            primitives.addAll(this.getPrimitiveVectors(listVector.getDataVector()));
        } else if (v instanceof FixedSizeListVector) {
            FixedSizeListVector listVector = (FixedSizeListVector)v;
            primitives.addAll(this.getPrimitiveVectors(listVector.getDataVector()));
        } else if (v instanceof UnionVector) {
            UnionVector unionVector = (UnionVector)v;
            for (FieldVector vector : unionVector.getChildrenFromFields()) {
                primitives.addAll(this.getPrimitiveVectors(vector));
            }
        } else {
            primitives.add(v);
        }
        return primitives;
    }

    @Override
    public VectorWithOrdinal getChildVectorWithOrdinal(String name) {
        int ordinal = this.vectors.getOrdinal(name);
        if (ordinal < 0) {
            return null;
        }
        ValueVector vector = this.vectors.getByOrdinal(ordinal);
        return new VectorWithOrdinal(vector, ordinal);
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrayList<ArrowBuf> buffers = new ArrayList<ArrowBuf>();
        for (ValueVector valueVector : this.vectors.values()) {
            for (ArrowBuf buf : valueVector.getBuffers(false)) {
                buffers.add(buf);
                if (!clear) continue;
                buf.getReferenceManager().retain(1);
            }
            if (!clear) continue;
            valueVector.clear();
        }
        return buffers.toArray(new ArrowBuf[buffers.size()]);
    }

    @Override
    public int getBufferSize() {
        int actualBufSize = 0;
        for (ValueVector valueVector : this.vectors.values()) {
            for (ArrowBuf buf : valueVector.getBuffers(false)) {
                actualBufSize += (int)buf.writerIndex();
            }
        }
        return actualBufSize;
    }

    @Override
    public String toString() {
        return ValueVectorUtility.getToString(this, 0, this.getValueCount());
    }

    static {
        ConflictPolicy conflictPolicy;
        logger = LoggerFactory.getLogger(AbstractContainerVector.class);
        String conflictPolicyStr = System.getProperty(STRUCT_CONFLICT_POLICY_JVM, ConflictPolicy.CONFLICT_REPLACE.toString());
        if (conflictPolicyStr == null) {
            conflictPolicyStr = System.getenv(STRUCT_CONFLICT_POLICY_ENV);
        }
        try {
            conflictPolicy = ConflictPolicy.valueOf(conflictPolicyStr.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            conflictPolicy = ConflictPolicy.CONFLICT_REPLACE;
        }
        DEFAULT_CONFLICT_POLICY = conflictPolicy;
    }

    public static enum ConflictPolicy {
        CONFLICT_APPEND,
        CONFLICT_IGNORE,
        CONFLICT_REPLACE,
        CONFLICT_ERROR;

    }
}

