/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector;

import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BaseIntVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.NullCheckingForGet;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueIterableVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.ValueVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.impl.IntReaderImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.IntHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.Types;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.util.TransferPair;

public final class IntVector
extends BaseFixedWidthVector
implements BaseIntVector,
ValueIterableVector<Integer> {
    public static final byte TYPE_WIDTH = 4;

    public IntVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.INT.getType()), allocator);
    }

    public IntVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public IntVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 4);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new IntReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INT;
    }

    public int get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getInt((long)index * 4L);
    }

    public void get(int index, NullableIntHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getInt((long)index * 4L);
    }

    @Override
    public Integer getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getInt((long)index * 4L);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setInt((long)index * 4L, value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableIntHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, IntHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableIntHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, IntHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, int value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, int value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public static int get(ArrowBuf buffer, int index) {
        return buffer.getInt((long)index * 4L);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntVector)to);
    }

    @Override
    public void setWithPossibleTruncate(int index, long value) {
        this.setSafe(index, (int)value);
    }

    @Override
    public void setUnsafeWithPossibleTruncate(int index, long value) {
        this.set(index, (int)value);
    }

    @Override
    public long getValueAsLong(int index) {
        return this.get(index);
    }

    private class TransferImpl
    implements TransferPair {
        IntVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new IntVector(ref, IntVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new IntVector(field, allocator);
        }

        public TransferImpl(IntVector to) {
            this.to = to;
        }

        @Override
        public IntVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntVector.this);
        }
    }
}

