/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.SessionOptionValue;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.SessionOptionValueFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;

public class SetSessionOptionsRequest {
    private final Map<String, SessionOptionValue> sessionOptions;

    public SetSessionOptionsRequest(Map<String, SessionOptionValue> sessionOptions) {
        this.sessionOptions = Collections.unmodifiableMap(new HashMap<String, SessionOptionValue>(sessionOptions));
    }

    SetSessionOptionsRequest(Flight.SetSessionOptionsRequest proto) {
        this.sessionOptions = Collections.unmodifiableMap(proto.getSessionOptionsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SessionOptionValueFactory.makeSessionOptionValue((Flight.SessionOptionValue)e.getValue()))));
    }

    public Map<String, SessionOptionValue> getSessionOptions() {
        return Collections.unmodifiableMap(this.sessionOptions);
    }

    Flight.SetSessionOptionsRequest toProtocol() {
        Flight.SetSessionOptionsRequest.Builder b = Flight.SetSessionOptionsRequest.newBuilder();
        b.putAllSessionOptions(this.sessionOptions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((SessionOptionValue)e.getValue()).toProtocol())));
        return b.build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static SetSessionOptionsRequest deserialize(ByteBuffer serialized) throws IOException {
        return new SetSessionOptionsRequest(Flight.SetSessionOptionsRequest.parseFrom(serialized));
    }
}

