/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import javax.net.ssl.SSLException;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Channel;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ClientCall;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ClientInterceptor;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ClientInterceptors;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.ManagedChannel;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.MethodDescriptor;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.StatusRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.netty.GrpcSslContexts;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.netty.NettyChannelBuilder;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.ClientCallStreamObserver;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.ClientCalls;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.ClientResponseObserver;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.stub.StreamObserver;
import org.apache.arrow.driver.jdbc.shaded.io.netty.channel.EventLoopGroup;
import org.apache.arrow.driver.jdbc.shaded.io.netty.channel.ServerChannel;
import org.apache.arrow.driver.jdbc.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.apache.arrow.driver.jdbc.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Action;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.ActionType;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.ArrowMessage;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallOptions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CancelFlightInfoRequest;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CancelFlightInfoResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CloseSessionRequest;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CloseSessionResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Criteria;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightConstants;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightStream;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.GetSessionOptionsRequest;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.GetSessionOptionsResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Location;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.NoOpStreamListener;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.OutboundStreamListener;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.OutboundStreamListenerImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.PollInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.PutResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.RenewFlightEndpointRequest;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Result;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.SchemaResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.SetSessionOptionsRequest;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.SetSessionOptionsResult;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.Ticket;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.BasicClientAuthHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ClientAuthHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ClientAuthInterceptor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth.ClientAuthWrapper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.BasicAuthCredentialWriter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.ClientBearerHeaderHandler;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.ClientHandshakeWrapper;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.auth2.ClientIncomingAuthHeaderMiddleware;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.ClientInterceptorAdapter;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.CredentialCallOption;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc.StatusUtils;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.impl.FlightServiceGrpc;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.Preconditions;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.dictionary.DictionaryProvider;

public class FlightClient
implements AutoCloseable {
    private static final int PENDING_REQUESTS = 5;
    private static final int MAX_CHANNEL_TRACE_EVENTS = 0;
    private final BufferAllocator allocator;
    private final ManagedChannel channel;
    private final FlightServiceGrpc.FlightServiceBlockingStub blockingStub;
    private final FlightServiceGrpc.FlightServiceStub asyncStub;
    private final ClientAuthInterceptor authInterceptor = new ClientAuthInterceptor();
    private final MethodDescriptor<Flight.Ticket, ArrowMessage> doGetDescriptor;
    private final MethodDescriptor<ArrowMessage, Flight.PutResult> doPutDescriptor;
    private final MethodDescriptor<ArrowMessage, ArrowMessage> doExchangeDescriptor;
    private final List<FlightClientMiddleware.Factory> middleware;

    FlightClient(BufferAllocator incomingAllocator, ManagedChannel channel, List<FlightClientMiddleware.Factory> middleware) {
        this.allocator = incomingAllocator.newChildAllocator("flight-client", 0L, Long.MAX_VALUE);
        this.channel = channel;
        this.middleware = middleware;
        ClientInterceptor[] interceptors = new ClientInterceptor[]{this.authInterceptor, new ClientInterceptorAdapter(middleware)};
        Channel interceptedChannel = ClientInterceptors.intercept((Channel)channel, interceptors);
        this.blockingStub = FlightServiceGrpc.newBlockingStub(interceptedChannel);
        this.asyncStub = FlightServiceGrpc.newStub(interceptedChannel);
        this.doGetDescriptor = FlightBindingService.getDoGetDescriptor(this.allocator);
        this.doPutDescriptor = FlightBindingService.getDoPutDescriptor(this.allocator);
        this.doExchangeDescriptor = FlightBindingService.getDoExchangeDescriptor(this.allocator);
    }

    public Iterable<FlightInfo> listFlights(Criteria criteria, CallOption ... options) {
        Iterator<Flight.FlightInfo> flights;
        try {
            flights = CallOptions.wrapStub(this.blockingStub, options).listFlights(criteria.asCriteria());
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
        return () -> StatusUtils.wrapIterator(flights, t -> {
            try {
                return new FlightInfo((Flight.FlightInfo)t);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Iterable<ActionType> listActions(CallOption ... options) {
        Iterator<Flight.ActionType> actions;
        try {
            actions = CallOptions.wrapStub(this.blockingStub, options).listActions(Flight.Empty.getDefaultInstance());
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
        return () -> StatusUtils.wrapIterator(actions, ActionType::new);
    }

    public Iterator<Result> doAction(Action action, CallOption ... options) {
        return StatusUtils.wrapIterator(CallOptions.wrapStub(this.blockingStub, options).doAction(action.toProtocol()), Result::new);
    }

    public void authenticateBasic(String username, String password) {
        BasicClientAuthHandler basicClient = new BasicClientAuthHandler(username, password);
        this.authenticate(basicClient, new CallOption[0]);
    }

    public void authenticate(ClientAuthHandler handler, CallOption ... options) {
        Preconditions.checkArgument(!this.authInterceptor.hasAuthHandler(), "Auth already completed.");
        ClientAuthWrapper.doClientAuth(handler, CallOptions.wrapStub(this.asyncStub, options));
        this.authInterceptor.setAuthHandler(handler);
    }

    public Optional<CredentialCallOption> authenticateBasicToken(String username, String password) {
        ClientIncomingAuthHeaderMiddleware.Factory clientAuthMiddleware = new ClientIncomingAuthHeaderMiddleware.Factory(new ClientBearerHeaderHandler());
        this.middleware.add(clientAuthMiddleware);
        this.handshake(new CredentialCallOption(new BasicAuthCredentialWriter(username, password)));
        return Optional.ofNullable(clientAuthMiddleware.getCredentialCallOption());
    }

    public void handshake(CallOption ... options) {
        ClientHandshakeWrapper.doClientHandshake(CallOptions.wrapStub(this.asyncStub, options));
    }

    public ClientStreamListener startPut(FlightDescriptor descriptor, VectorSchemaRoot root, PutListener metadataListener, CallOption ... options) {
        return this.startPut(descriptor, root, new DictionaryProvider.MapDictionaryProvider(new Dictionary[0]), metadataListener, options);
    }

    public ClientStreamListener startPut(FlightDescriptor descriptor, VectorSchemaRoot root, DictionaryProvider provider, PutListener metadataListener, CallOption ... options) {
        Preconditions.checkNotNull(root, "root must not be null");
        Preconditions.checkNotNull(provider, "provider must not be null");
        ClientStreamListener writer = this.startPut(descriptor, metadataListener, options);
        writer.start(root, provider);
        return writer;
    }

    public ClientStreamListener startPut(FlightDescriptor descriptor, PutListener metadataListener, CallOption ... options) {
        Preconditions.checkNotNull(descriptor, "descriptor must not be null");
        Preconditions.checkNotNull(metadataListener, "metadataListener must not be null");
        try {
            ClientCall<ArrowMessage, Flight.PutResult> call = this.asyncStubNewCall(this.doPutDescriptor, options);
            SetStreamObserver resultObserver = new SetStreamObserver(this.allocator, metadataListener);
            ClientCallStreamObserver observer = (ClientCallStreamObserver)ClientCalls.asyncBidiStreamingCall(call, resultObserver);
            return new PutObserver(descriptor, observer, metadataListener::isCancelled, metadataListener::getResult);
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
    }

    public FlightInfo getInfo(FlightDescriptor descriptor, CallOption ... options) {
        try {
            return new FlightInfo(CallOptions.wrapStub(this.blockingStub, options).getFlightInfo(descriptor.toProtocol()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
    }

    public PollInfo pollInfo(FlightDescriptor descriptor, CallOption ... options) {
        try {
            return new PollInfo(CallOptions.wrapStub(this.blockingStub, options).pollFlightInfo(descriptor.toProtocol()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
    }

    public SchemaResult getSchema(FlightDescriptor descriptor, CallOption ... options) {
        try {
            return SchemaResult.fromProtocol(CallOptions.wrapStub(this.blockingStub, options).getSchema(descriptor.toProtocol()));
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
    }

    public FlightStream getStream(Ticket ticket, CallOption ... options) {
        ClientCall<Flight.Ticket, ArrowMessage> call = this.asyncStubNewCall(this.doGetDescriptor, options);
        FlightStream stream = new FlightStream(this.allocator, 5, (message, cause) -> call.cancel(message, cause), count -> call.request(count));
        final StreamObserver<ArrowMessage> delegate = stream.asObserver();
        ClientResponseObserver<Flight.Ticket, ArrowMessage> clientResponseObserver = new ClientResponseObserver<Flight.Ticket, ArrowMessage>(){

            @Override
            public void beforeStart(ClientCallStreamObserver<Flight.Ticket> requestStream) {
                requestStream.disableAutoInboundFlowControl();
            }

            @Override
            public void onNext(ArrowMessage value) {
                delegate.onNext(value);
            }

            @Override
            public void onError(Throwable t) {
                delegate.onError(StatusUtils.toGrpcException(t));
            }

            @Override
            public void onCompleted() {
                delegate.onCompleted();
            }
        };
        ClientCalls.asyncServerStreamingCall(call, ticket.toProtocol(), clientResponseObserver);
        return stream;
    }

    public ExchangeReaderWriter doExchange(FlightDescriptor descriptor, CallOption ... options) {
        Preconditions.checkNotNull(descriptor, "descriptor must not be null");
        try {
            ClientCall<ArrowMessage, ArrowMessage> call = this.asyncStubNewCall(this.doExchangeDescriptor, options);
            FlightStream stream = new FlightStream(this.allocator, 5, call::cancel, call::request);
            ClientCallStreamObserver observer = (ClientCallStreamObserver)ClientCalls.asyncBidiStreamingCall(call, stream.asObserver());
            PutObserver writer = new PutObserver(descriptor, observer, stream.cancelled::isDone, () -> {
                try {
                    stream.completed.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw CallStatus.INTERNAL.withDescription("Client error: interrupted while completing call").withCause(e).toRuntimeException();
                }
                catch (ExecutionException e) {
                    throw CallStatus.INTERNAL.withDescription("Client error: internal while completing call").withCause(e).toRuntimeException();
                }
            });
            try (ArrowMessage message = new ArrowMessage(descriptor.toProtocol());){
                observer.onNext(message);
            }
            catch (Exception e) {
                throw CallStatus.INTERNAL.withCause(e).withDescription("Could not write descriptor " + String.valueOf(descriptor)).toRuntimeException();
            }
            return new ExchangeReaderWriter(stream, writer);
        }
        catch (StatusRuntimeException sre) {
            throw StatusUtils.fromGrpcRuntimeException(sre);
        }
    }

    public CancelFlightInfoResult cancelFlightInfo(CancelFlightInfoRequest request, CallOption ... options) {
        CancelFlightInfoResult result;
        Action action = new Action(FlightConstants.CANCEL_FLIGHT_INFO.getType(), request.serialize().array());
        Iterator<Result> results = this.doAction(action, options);
        if (!results.hasNext()) {
            throw CallStatus.INTERNAL.withDescription("Server did not return a response").toRuntimeException();
        }
        try {
            result = CancelFlightInfoResult.deserialize(ByteBuffer.wrap(results.next().getBody()));
        }
        catch (IOException e) {
            throw CallStatus.INTERNAL.withDescription("Failed to parse server response: " + String.valueOf(e)).withCause(e).toRuntimeException();
        }
        results.forEachRemaining(ignored -> {});
        return result;
    }

    public FlightEndpoint renewFlightEndpoint(RenewFlightEndpointRequest request, CallOption ... options) {
        FlightEndpoint result;
        Action action = new Action(FlightConstants.RENEW_FLIGHT_ENDPOINT.getType(), request.serialize().array());
        Iterator<Result> results = this.doAction(action, options);
        if (!results.hasNext()) {
            throw CallStatus.INTERNAL.withDescription("Server did not return a response").toRuntimeException();
        }
        try {
            result = FlightEndpoint.deserialize(ByteBuffer.wrap(results.next().getBody()));
        }
        catch (IOException | URISyntaxException e) {
            throw CallStatus.INTERNAL.withDescription("Failed to parse server response: " + String.valueOf(e)).withCause(e).toRuntimeException();
        }
        results.forEachRemaining(ignored -> {});
        return result;
    }

    public SetSessionOptionsResult setSessionOptions(SetSessionOptionsRequest request, CallOption ... options) {
        SetSessionOptionsResult result;
        Action action = new Action(FlightConstants.SET_SESSION_OPTIONS.getType(), request.serialize().array());
        Iterator<Result> results = this.doAction(action, options);
        if (!results.hasNext()) {
            throw CallStatus.INTERNAL.withDescription("Server did not return a response").toRuntimeException();
        }
        try {
            result = SetSessionOptionsResult.deserialize(ByteBuffer.wrap(results.next().getBody()));
        }
        catch (IOException e) {
            throw CallStatus.INTERNAL.withDescription("Failed to parse server response: " + String.valueOf(e)).withCause(e).toRuntimeException();
        }
        results.forEachRemaining(ignored -> {});
        return result;
    }

    public GetSessionOptionsResult getSessionOptions(GetSessionOptionsRequest request, CallOption ... options) {
        GetSessionOptionsResult result;
        Action action = new Action(FlightConstants.GET_SESSION_OPTIONS.getType(), request.serialize().array());
        Iterator<Result> results = this.doAction(action, options);
        if (!results.hasNext()) {
            throw CallStatus.INTERNAL.withDescription("Server did not return a response").toRuntimeException();
        }
        try {
            result = GetSessionOptionsResult.deserialize(ByteBuffer.wrap(results.next().getBody()));
        }
        catch (IOException e) {
            throw CallStatus.INTERNAL.withDescription("Failed to parse server response: " + String.valueOf(e)).withCause(e).toRuntimeException();
        }
        results.forEachRemaining(ignored -> {});
        return result;
    }

    public CloseSessionResult closeSession(CloseSessionRequest request, CallOption ... options) {
        CloseSessionResult result;
        Action action = new Action(FlightConstants.CLOSE_SESSION.getType(), request.serialize().array());
        Iterator<Result> results = this.doAction(action, options);
        if (!results.hasNext()) {
            throw CallStatus.INTERNAL.withDescription("Server did not return a response").toRuntimeException();
        }
        try {
            result = CloseSessionResult.deserialize(ByteBuffer.wrap(results.next().getBody()));
        }
        catch (IOException e) {
            throw CallStatus.INTERNAL.withDescription("Failed to parse server response: " + String.valueOf(e)).withCause(e).toRuntimeException();
        }
        results.forEachRemaining(ignored -> {});
        return result;
    }

    @Override
    public void close() throws InterruptedException {
        this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        this.allocator.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BufferAllocator allocator, Location location) {
        return new Builder(allocator, location);
    }

    private <RequestT, ResponseT> ClientCall<RequestT, ResponseT> asyncStubNewCall(MethodDescriptor<RequestT, ResponseT> descriptor, CallOption ... options) {
        FlightServiceGrpc.FlightServiceStub wrappedStub = CallOptions.wrapStub(this.asyncStub, options);
        return wrappedStub.getChannel().newCall(descriptor, wrappedStub.getCallOptions());
    }

    public static interface PutListener
    extends FlightProducer.StreamListener<PutResult> {
        public void getResult();

        @Override
        public void onNext(PutResult var1);

        default public boolean isCancelled() {
            return false;
        }
    }

    public static interface ClientStreamListener
    extends OutboundStreamListener {
        public void getResult();
    }

    private static class SetStreamObserver
    implements StreamObserver<Flight.PutResult> {
        private final BufferAllocator allocator;
        private final FlightProducer.StreamListener<PutResult> listener;

        SetStreamObserver(BufferAllocator allocator, FlightProducer.StreamListener<PutResult> listener) {
            this.allocator = allocator;
            this.listener = listener == null ? NoOpStreamListener.getInstance() : listener;
        }

        @Override
        public void onNext(Flight.PutResult value) {
            try (PutResult message = PutResult.fromProtocol(this.allocator, value);){
                this.listener.onNext(message);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.listener.onError(StatusUtils.fromThrowable(t));
        }

        @Override
        public void onCompleted() {
            this.listener.onCompleted();
        }
    }

    static class PutObserver
    extends OutboundStreamListenerImpl
    implements ClientStreamListener {
        private final BooleanSupplier isCancelled;
        private final Runnable getResult;

        PutObserver(FlightDescriptor descriptor, ClientCallStreamObserver<ArrowMessage> observer, BooleanSupplier isCancelled, Runnable getResult) {
            super(descriptor, observer);
            Preconditions.checkNotNull(descriptor, "descriptor must be provided");
            Preconditions.checkNotNull(isCancelled, "isCancelled must be provided");
            Preconditions.checkNotNull(getResult, "getResult must be provided");
            this.isCancelled = isCancelled;
            this.getResult = getResult;
            this.unloader = null;
        }

        @Override
        protected void waitUntilStreamReady() {
            while (!this.responseObserver.isReady() && !this.isCancelled.getAsBoolean()) {
            }
        }

        @Override
        public void getResult() {
            this.getResult.run();
        }
    }

    public static class ExchangeReaderWriter
    implements AutoCloseable {
        private final FlightStream reader;
        private final ClientStreamListener writer;

        ExchangeReaderWriter(FlightStream reader, ClientStreamListener writer) {
            this.reader = reader;
            this.writer = writer;
        }

        public FlightStream getReader() {
            return this.reader;
        }

        public ClientStreamListener getWriter() {
            return this.writer;
        }

        public void getResult() {
            while (this.reader.next()) {
            }
        }

        @Override
        public void close() throws Exception {
            this.reader.close();
        }
    }

    public static final class Builder {
        private BufferAllocator allocator;
        private Location location;
        private boolean forceTls = false;
        private int maxInboundMessageSize = Integer.MAX_VALUE;
        private InputStream trustedCertificates = null;
        private InputStream clientCertificate = null;
        private InputStream clientKey = null;
        private String overrideHostname = null;
        private List<FlightClientMiddleware.Factory> middleware = new ArrayList<FlightClientMiddleware.Factory>();
        private boolean verifyServer = true;

        private Builder() {
        }

        private Builder(BufferAllocator allocator, Location location) {
            this.allocator = Preconditions.checkNotNull(allocator);
            this.location = Preconditions.checkNotNull(location);
        }

        public Builder useTls() {
            this.forceTls = true;
            return this;
        }

        public Builder overrideHostname(String hostname) {
            this.overrideHostname = hostname;
            return this;
        }

        public Builder maxInboundMessageSize(int maxSize) {
            Preconditions.checkArgument(maxSize > 0);
            this.maxInboundMessageSize = maxSize;
            return this;
        }

        public Builder trustedCertificates(InputStream stream) {
            this.trustedCertificates = Preconditions.checkNotNull(stream);
            return this;
        }

        public Builder clientCertificate(InputStream clientCertificate, InputStream clientKey) {
            Preconditions.checkNotNull(clientKey);
            this.clientCertificate = Preconditions.checkNotNull(clientCertificate);
            this.clientKey = Preconditions.checkNotNull(clientKey);
            return this;
        }

        public Builder allocator(BufferAllocator allocator) {
            this.allocator = Preconditions.checkNotNull(allocator);
            return this;
        }

        public Builder location(Location location) {
            this.location = Preconditions.checkNotNull(location);
            return this;
        }

        public Builder intercept(FlightClientMiddleware.Factory factory) {
            this.middleware.add(factory);
            return this;
        }

        public Builder verifyServer(boolean verifyServer) {
            this.verifyServer = verifyServer;
            return this;
        }

        public FlightClient build() {
            NettyChannelBuilder builder;
            switch (this.location.getUri().getScheme()) {
                case "grpc": 
                case "grpc+tcp": 
                case "grpc+tls": {
                    builder = NettyChannelBuilder.forAddress(this.location.toSocketAddress());
                    break;
                }
                case "grpc+unix": {
                    builder = NettyChannelBuilder.forAddress(this.location.toSocketAddress());
                    try {
                        try {
                            builder.channelType(Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.epoll.EpollDomainSocketChannel").asSubclass(ServerChannel.class));
                            EventLoopGroup elg = Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.epoll.EpollEventLoopGroup").asSubclass(EventLoopGroup.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            builder.eventLoopGroup(elg);
                        }
                        catch (ClassNotFoundException e) {
                            builder.channelType(Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.kqueue.KQueueDomainSocketChannel").asSubclass(ServerChannel.class));
                            EventLoopGroup elg = Class.forName("org.apache.arrow.driver.jdbc.shaded.io.netty.channel.kqueue.KQueueEventLoopGroup").asSubclass(EventLoopGroup.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            builder.eventLoopGroup(elg);
                        }
                        break;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new UnsupportedOperationException("Could not find suitable Netty native transport implementation for domain socket address.");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Scheme is not supported: " + this.location.getUri().getScheme());
                }
            }
            if (this.forceTls || "grpc+tls".equals(this.location.getUri().getScheme())) {
                boolean hasKeyCertPair;
                builder.useTransportSecurity();
                boolean hasTrustedCerts = this.trustedCertificates != null;
                boolean bl = hasKeyCertPair = this.clientCertificate != null && this.clientKey != null;
                if (!this.verifyServer && (hasTrustedCerts || hasKeyCertPair)) {
                    throw new IllegalArgumentException("FlightClient has been configured to disable server verification, but certificate options have been specified.");
                }
                SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
                if (!this.verifyServer) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                } else if (this.trustedCertificates != null || this.clientCertificate != null || this.clientKey != null) {
                    if (this.trustedCertificates != null) {
                        sslContextBuilder.trustManager(this.trustedCertificates);
                    }
                    if (this.clientCertificate != null && this.clientKey != null) {
                        sslContextBuilder.keyManager(this.clientCertificate, this.clientKey);
                    }
                }
                try {
                    builder.sslContext(sslContextBuilder.build());
                }
                catch (SSLException e) {
                    throw new RuntimeException(e);
                }
                if (this.overrideHostname != null) {
                    builder.overrideAuthority(this.overrideHostname);
                }
            } else {
                builder.usePlaintext();
            }
            ((NettyChannelBuilder)builder.maxTraceEvents(0)).maxInboundMessageSize(this.maxInboundMessageSize).maxInboundMetadataSize(this.maxInboundMessageSize);
            return new FlightClient(this.allocator, builder.build(), this.middleware);
        }
    }
}

