/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.grpc;

import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.InternalMetadata;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Metadata;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.Status;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.StatusException;
import org.apache.arrow.driver.jdbc.shaded.io.grpc.StatusRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.CallStatus;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.ErrorFlightMetadata;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightStatusCode;

public class StatusUtils {
    private StatusUtils() {
        throw new AssertionError((Object)"Do not instantiate this class.");
    }

    public static Status.Code toGrpcStatusCode(FlightStatusCode code) {
        switch (code) {
            case OK: {
                return Status.Code.OK;
            }
            case UNKNOWN: {
                return Status.Code.UNKNOWN;
            }
            case INTERNAL: {
                return Status.Code.INTERNAL;
            }
            case INVALID_ARGUMENT: {
                return Status.Code.INVALID_ARGUMENT;
            }
            case TIMED_OUT: {
                return Status.Code.DEADLINE_EXCEEDED;
            }
            case NOT_FOUND: {
                return Status.Code.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return Status.Code.ALREADY_EXISTS;
            }
            case CANCELLED: {
                return Status.Code.CANCELLED;
            }
            case UNAUTHENTICATED: {
                return Status.Code.UNAUTHENTICATED;
            }
            case UNAUTHORIZED: {
                return Status.Code.PERMISSION_DENIED;
            }
            case UNIMPLEMENTED: {
                return Status.Code.UNIMPLEMENTED;
            }
            case UNAVAILABLE: {
                return Status.Code.UNAVAILABLE;
            }
            case RESOURCE_EXHAUSTED: {
                return Status.Code.RESOURCE_EXHAUSTED;
            }
        }
        return Status.Code.UNKNOWN;
    }

    public static FlightStatusCode fromGrpcStatusCode(Status.Code code) {
        switch (code) {
            case OK: {
                return FlightStatusCode.OK;
            }
            case CANCELLED: {
                return FlightStatusCode.CANCELLED;
            }
            case UNKNOWN: {
                return FlightStatusCode.UNKNOWN;
            }
            case INVALID_ARGUMENT: {
                return FlightStatusCode.INVALID_ARGUMENT;
            }
            case DEADLINE_EXCEEDED: {
                return FlightStatusCode.TIMED_OUT;
            }
            case NOT_FOUND: {
                return FlightStatusCode.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return FlightStatusCode.ALREADY_EXISTS;
            }
            case PERMISSION_DENIED: {
                return FlightStatusCode.UNAUTHORIZED;
            }
            case RESOURCE_EXHAUSTED: {
                return FlightStatusCode.RESOURCE_EXHAUSTED;
            }
            case FAILED_PRECONDITION: {
                return FlightStatusCode.INVALID_ARGUMENT;
            }
            case ABORTED: {
                return FlightStatusCode.INTERNAL;
            }
            case OUT_OF_RANGE: {
                return FlightStatusCode.INVALID_ARGUMENT;
            }
            case UNIMPLEMENTED: {
                return FlightStatusCode.UNIMPLEMENTED;
            }
            case INTERNAL: {
                return FlightStatusCode.INTERNAL;
            }
            case UNAVAILABLE: {
                return FlightStatusCode.UNAVAILABLE;
            }
            case DATA_LOSS: {
                return FlightStatusCode.INTERNAL;
            }
            case UNAUTHENTICATED: {
                return FlightStatusCode.UNAUTHENTICATED;
            }
        }
        return FlightStatusCode.UNKNOWN;
    }

    static Metadata.Key<byte[]> keyOfBinary(String name) {
        return Metadata.Key.of(name, Metadata.BINARY_BYTE_MARSHALLER);
    }

    static Metadata.Key<String> keyOfAscii(String name) {
        return InternalMetadata.keyOf(name, Metadata.ASCII_STRING_MARSHALLER);
    }

    public static CallStatus fromGrpcStatusAndTrailers(Status status, Metadata trailers) {
        ErrorFlightMetadata errorMetadata = trailers == null ? null : StatusUtils.parseTrailers(trailers);
        return new CallStatus(StatusUtils.fromGrpcStatusCode(status.getCode()), status.getCause(), status.getDescription(), errorMetadata);
    }

    public static CallStatus fromGrpcStatus(Status status) {
        return new CallStatus(StatusUtils.fromGrpcStatusCode(status.getCode()), status.getCause(), status.getDescription(), null);
    }

    public static Status toGrpcStatus(CallStatus status) {
        return StatusUtils.toGrpcStatusCode(status.code()).toStatus().withDescription(status.description()).withCause(status.cause());
    }

    public static FlightRuntimeException fromGrpcRuntimeException(StatusRuntimeException sre) {
        return StatusUtils.fromGrpcStatusAndTrailers(sre.getStatus(), sre.getTrailers()).toRuntimeException();
    }

    private static ErrorFlightMetadata parseTrailers(Metadata trailers) {
        ErrorFlightMetadata metadata = new ErrorFlightMetadata();
        for (String key : trailers.keys()) {
            if (key.endsWith("-bin")) {
                metadata.insert(key, trailers.get(StatusUtils.keyOfBinary(key)));
                continue;
            }
            metadata.insert(key, Objects.requireNonNull(trailers.get(StatusUtils.keyOfAscii(key))).getBytes(StandardCharsets.UTF_8));
        }
        return metadata;
    }

    public static FlightRuntimeException fromThrowable(Throwable t) {
        if (t instanceof StatusRuntimeException) {
            return StatusUtils.fromGrpcRuntimeException((StatusRuntimeException)t);
        }
        if (t instanceof FlightRuntimeException) {
            return (FlightRuntimeException)t;
        }
        return CallStatus.UNKNOWN.withCause(t).withDescription(t.getMessage()).toRuntimeException();
    }

    public static Throwable toGrpcException(Throwable ex) {
        if (ex instanceof StatusRuntimeException) {
            return ex;
        }
        if (ex instanceof StatusException) {
            return ex;
        }
        if (ex instanceof FlightRuntimeException) {
            FlightRuntimeException fre = (FlightRuntimeException)ex;
            if (fre.status().metadata() != null) {
                Metadata trailers = StatusUtils.toGrpcMetadata(fre.status().metadata());
                return new StatusRuntimeException(StatusUtils.toGrpcStatus(fre.status()), trailers);
            }
            return StatusUtils.toGrpcStatus(fre.status()).asRuntimeException();
        }
        return Status.INTERNAL.withCause(ex).withDescription("There was an error servicing your request.").asRuntimeException();
    }

    private static Metadata toGrpcMetadata(ErrorFlightMetadata metadata) {
        Metadata trailers = new Metadata();
        for (String key : metadata.keys()) {
            if (key.endsWith("-bin")) {
                trailers.put(StatusUtils.keyOfBinary(key), metadata.getByte(key));
                continue;
            }
            trailers.put(StatusUtils.keyOfAscii(key), metadata.get(key));
        }
        return trailers;
    }

    public static <FROM, TO> Iterator<TO> wrapIterator(final Iterator<FROM> fromIterator, final Function<? super FROM, ? extends TO> transformer) {
        Objects.requireNonNull(fromIterator);
        Objects.requireNonNull(transformer);
        return new Iterator<TO>(){

            @Override
            public boolean hasNext() {
                try {
                    return fromIterator.hasNext();
                }
                catch (StatusRuntimeException e) {
                    throw StatusUtils.fromGrpcRuntimeException(e);
                }
            }

            @Override
            public TO next() {
                try {
                    return transformer.apply(fromIterator.next());
                }
                catch (StatusRuntimeException e) {
                    throw StatusUtils.fromGrpcRuntimeException(e);
                }
            }
        };
    }
}

