/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcCursor;
import org.apache.arrow.driver.jdbc.ArrowFlightMetaImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;
import org.apache.arrow.driver.jdbc.utils.ConvertUtils;

public class ArrowFlightJdbcVectorSchemaRootResultSet
extends AvaticaResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowFlightJdbcVectorSchemaRootResultSet.class);
    VectorSchemaRoot vectorSchemaRoot;

    ArrowFlightJdbcVectorSchemaRootResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
    }

    public static ArrowFlightJdbcVectorSchemaRootResultSet fromVectorSchemaRoot(VectorSchemaRoot vectorSchemaRoot) throws SQLException {
        TimeZone timeZone = TimeZone.getDefault();
        QueryState state = new QueryState();
        Meta.Signature signature = ArrowFlightMetaImpl.newSignature(null, null, null);
        AvaticaResultSetMetaData resultSetMetaData = new AvaticaResultSetMetaData(null, null, signature);
        ArrowFlightJdbcVectorSchemaRootResultSet resultSet = new ArrowFlightJdbcVectorSchemaRootResultSet(null, state, signature, resultSetMetaData, timeZone, null);
        resultSet.populateData(vectorSchemaRoot);
        return resultSet;
    }

    @Override
    protected AvaticaResultSet execute() throws SQLException {
        throw new RuntimeException("Can only execute with execute(VectorSchemaRoot)");
    }

    void populateData(VectorSchemaRoot vectorSchemaRoot) {
        this.populateData(vectorSchemaRoot, null);
    }

    void populateData(VectorSchemaRoot vectorSchemaRoot, Schema schema) {
        Schema currentSchema = schema == null ? vectorSchemaRoot.getSchema() : schema;
        List<ColumnMetaData> columns = ConvertUtils.convertArrowFieldsToColumnMetaDataList(currentSchema.getFields());
        this.signature.columns.clear();
        this.signature.columns.addAll(columns);
        this.vectorSchemaRoot = vectorSchemaRoot;
        this.execute2(new ArrowFlightJdbcCursor(vectorSchemaRoot), this.signature.columns);
    }

    @Override
    protected void cancel() {
        this.signature.columns.clear();
        super.cancel();
        try {
            AutoCloseables.close(this.vectorSchemaRoot);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        HashSet<Exception> exceptions = new HashSet<Exception>();
        try {
            if (this.isClosed()) {
                return;
            }
        }
        catch (SQLException e2) {
            exceptions.add(e2);
        }
        try {
            AutoCloseables.close(this.vectorSchemaRoot);
        }
        catch (Exception e3) {
            exceptions.add(e3);
        }
        if (!Objects.isNull(this.statement)) {
            try {
                super.close();
            }
            catch (Exception e4) {
                exceptions.add(e4);
            }
        }
        exceptions.parallelStream().forEach(e -> LOGGER.error(e.getMessage(), (Throwable)e));
        exceptions.stream().findAny().ifPresent(e -> {
            throw new RuntimeException((Throwable)e);
        });
    }
}

