/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.driver.jdbc.ArrowFlightConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightInfoStatement;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcVectorSchemaRootResultSet;
import org.apache.arrow.driver.jdbc.ArrowFlightMetaImpl;
import org.apache.arrow.driver.jdbc.client.CloseableEndpointStreamPair;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSetMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.arrow.driver.jdbc.utils.FlightEndpointDataQueue;
import org.apache.arrow.driver.jdbc.utils.VectorSchemaRootTransformer;

public final class ArrowFlightJdbcFlightStreamResultSet
extends ArrowFlightJdbcVectorSchemaRootResultSet {
    private final ArrowFlightConnection connection;
    private final FlightInfo flightInfo;
    private CloseableEndpointStreamPair currentEndpointData;
    private FlightEndpointDataQueue flightEndpointDataQueue;
    private VectorSchemaRootTransformer transformer;
    private VectorSchemaRoot currentVectorSchemaRoot;
    private Schema schema;

    ArrowFlightJdbcFlightStreamResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
        this.connection = (ArrowFlightConnection)statement.connection;
        this.flightInfo = ((ArrowFlightInfoStatement)((Object)statement)).executeFlightInfoQuery();
    }

    private ArrowFlightJdbcFlightStreamResultSet(ArrowFlightConnection connection, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame, FlightInfo flightInfo) throws SQLException {
        super(null, state, signature, resultSetMetaData, timeZone, firstFrame);
        this.connection = connection;
        this.flightInfo = flightInfo;
    }

    static ArrowFlightJdbcFlightStreamResultSet fromFlightInfo(ArrowFlightConnection connection, FlightInfo flightInfo, VectorSchemaRootTransformer transformer) throws SQLException {
        TimeZone timeZone = TimeZone.getDefault();
        QueryState state = new QueryState();
        Meta.Signature signature = ArrowFlightMetaImpl.newSignature(null, null, null);
        AvaticaResultSetMetaData resultSetMetaData = new AvaticaResultSetMetaData(null, null, signature);
        ArrowFlightJdbcFlightStreamResultSet resultSet = new ArrowFlightJdbcFlightStreamResultSet(connection, state, signature, resultSetMetaData, timeZone, null, flightInfo);
        resultSet.transformer = transformer;
        resultSet.populateData();
        return resultSet;
    }

    private void loadNewQueue() {
        Optional.ofNullable(this.flightEndpointDataQueue).ifPresent(AutoCloseables::closeNoChecked);
        this.flightEndpointDataQueue = FlightEndpointDataQueue.createNewQueue(this.connection.getExecutorService());
    }

    private void loadNewFlightStream() throws SQLException {
        if (this.currentEndpointData != null) {
            AutoCloseables.closeNoChecked(this.currentEndpointData);
        }
        this.currentEndpointData = this.getNextEndpointStream(true);
    }

    @Override
    protected AvaticaResultSet execute() throws SQLException {
        if (this.flightInfo != null) {
            this.schema = this.flightInfo.getSchemaOptional().orElse(null);
            this.populateData();
        }
        return this;
    }

    private void populateData() throws SQLException {
        this.loadNewQueue();
        this.flightEndpointDataQueue.enqueue(this.connection.getClientHandler().getStreams(this.flightInfo));
        this.loadNewFlightStream();
        if (this.currentEndpointData != null) {
            this.populateDataForCurrentFlightStream();
        }
    }

    private void populateDataForCurrentFlightStream() throws SQLException {
        VectorSchemaRoot originalRoot = this.currentEndpointData.getStream().getRoot();
        if (this.transformer != null) {
            try {
                this.currentVectorSchemaRoot = this.transformer.transform(originalRoot, this.currentVectorSchemaRoot);
            }
            catch (Exception e) {
                throw new SQLException("Failed to transform VectorSchemaRoot.", e);
            }
        } else {
            this.currentVectorSchemaRoot = originalRoot;
        }
        this.populateData(this.currentVectorSchemaRoot, this.schema);
    }

    public byte[] getAppMetadata() {
        return this.flightInfo.getAppMetadata();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.currentVectorSchemaRoot == null) {
            return false;
        }
        while (true) {
            int maxRows;
            boolean hasNext = super.next();
            int n = maxRows = this.statement != null ? this.statement.getMaxRows() : 0;
            if (maxRows != 0 && this.getRow() > maxRows) {
                if (this.statement.isCloseOnCompletion()) {
                    this.statement.close();
                }
                return false;
            }
            if (hasNext) {
                return true;
            }
            if (this.currentEndpointData != null) {
                this.currentEndpointData.getStream().getRoot().clear();
                if (this.currentEndpointData.getStream().next()) {
                    this.populateDataForCurrentFlightStream();
                    continue;
                }
                this.flightEndpointDataQueue.enqueue(this.currentEndpointData);
            }
            this.currentEndpointData = this.getNextEndpointStream(false);
            if (this.currentEndpointData == null) break;
            this.populateDataForCurrentFlightStream();
        }
        if (this.statement != null && this.statement.isCloseOnCompletion()) {
            this.statement.close();
        }
        return false;
    }

    @Override
    protected void cancel() {
        super.cancel();
        CloseableEndpointStreamPair currentEndpoint = this.currentEndpointData;
        if (currentEndpoint != null) {
            currentEndpoint.getStream().cancel("Cancel", null);
        }
        if (this.flightEndpointDataQueue != null) {
            try {
                this.flightEndpointDataQueue.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.flightEndpointDataQueue != null) {
                this.flightEndpointDataQueue.close();
            } else if (this.currentEndpointData != null) {
                this.currentEndpointData.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            super.close();
        }
    }

    private CloseableEndpointStreamPair getNextEndpointStream(boolean canTimeout) throws SQLException {
        if (canTimeout) {
            int statementTimeout = this.statement != null ? this.statement.getQueryTimeout() : 0;
            return statementTimeout != 0 ? this.flightEndpointDataQueue.next(statementTimeout, TimeUnit.SECONDS) : this.flightEndpointDataQueue.next();
        }
        return this.flightEndpointDataQueue.next();
    }
}

