/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.arrow.driver.jdbc.accessor.ArrowFlightJdbcAccessorFactory;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.FieldVector;
import org.apache.arrow.driver.jdbc.shaded.org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.arrow.driver.jdbc.shaded.org.apache.calcite.avatica.util.Cursor;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.Logger;
import org.apache.arrow.driver.jdbc.shaded.org.slf4j.LoggerFactory;

public class ArrowFlightJdbcCursor
extends AbstractCursor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrowFlightJdbcCursor.class);
    private final VectorSchemaRoot root;
    private final int rowCount;
    private int currentRow = -1;

    public ArrowFlightJdbcCursor(VectorSchemaRoot root) {
        this.root = root;
        this.rowCount = root.getRowCount();
    }

    @Override
    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> columns, Calendar localCalendar, ArrayImpl.Factory factory) {
        List<FieldVector> fieldVectors = this.root.getFieldVectors();
        return IntStream.range(0, fieldVectors.size()).mapToObj(this.root::getVector).map(this::createAccessor).collect(Collectors.toCollection(() -> new ArrayList(fieldVectors.size())));
    }

    private Cursor.Accessor createAccessor(FieldVector vector) {
        return ArrowFlightJdbcAccessorFactory.createAccessor(vector, this::getCurrentRow, wasNull -> {
            this.wasNull[0] = wasNull;
        });
    }

    @Override
    protected AbstractCursor.Getter createGetter(int column) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public boolean next() {
        ++this.currentRow;
        return this.currentRow < this.rowCount;
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close(this.root);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private int getCurrentRow() {
        return this.currentRow;
    }
}

