/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.driver.jdbc;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcDataSource;
import org.apache.arrow.driver.jdbc.ArrowFlightJdbcPooledConnection;
import org.apache.arrow.driver.jdbc.utils.ArrowFlightConnectionConfigImpl;

public class ArrowFlightJdbcConnectionPoolDataSource
extends ArrowFlightJdbcDataSource
implements ConnectionPoolDataSource,
ConnectionEventListener,
AutoCloseable {
    private final Map<Properties, Queue<ArrowFlightJdbcPooledConnection>> pool = new ConcurrentHashMap<Properties, Queue<ArrowFlightJdbcPooledConnection>>();

    protected ArrowFlightJdbcConnectionPoolDataSource(Properties properties, ArrowFlightConnectionConfigImpl config) {
        super(properties, config);
    }

    public static ArrowFlightJdbcConnectionPoolDataSource createNewDataSource(Properties properties) {
        return new ArrowFlightJdbcConnectionPoolDataSource(properties, new ArrowFlightConnectionConfigImpl(properties));
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        ArrowFlightConnectionConfigImpl config = this.getConfig();
        return this.getPooledConnection(config.getUser(), config.getPassword());
    }

    @Override
    public PooledConnection getPooledConnection(String username, String password) throws SQLException {
        Properties properties = this.getProperties(username, password);
        Queue objectPool = this.pool.computeIfAbsent(properties, s -> new ConcurrentLinkedQueue());
        ArrowFlightJdbcPooledConnection pooledConnection = (ArrowFlightJdbcPooledConnection)objectPool.poll();
        if (pooledConnection == null) {
            pooledConnection = this.createPooledConnection(new ArrowFlightConnectionConfigImpl(properties));
        } else {
            pooledConnection.reset();
        }
        return pooledConnection;
    }

    private ArrowFlightJdbcPooledConnection createPooledConnection(ArrowFlightConnectionConfigImpl config) throws SQLException {
        ArrowFlightJdbcPooledConnection pooledConnection = new ArrowFlightJdbcPooledConnection(this.getConnection(config.getUser(), config.getPassword()));
        pooledConnection.addConnectionEventListener(this);
        return pooledConnection;
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        ArrowFlightJdbcPooledConnection pooledConnection = (ArrowFlightJdbcPooledConnection)connectionEvent.getSource();
        Queue<ArrowFlightJdbcPooledConnection> connectionQueue = this.pool.get(pooledConnection.getProperties());
        connectionQueue.add(pooledConnection);
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
    }

    @Override
    public void close() throws Exception {
        SQLException lastException = null;
        for (Queue<ArrowFlightJdbcPooledConnection> connections : this.pool.values()) {
            while (!connections.isEmpty()) {
                PooledConnection pooledConnection = connections.poll();
                try {
                    pooledConnection.close();
                }
                catch (SQLException e) {
                    lastException = e;
                }
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }
}

