/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import org.apache.arrow.flight.AsyncPutListener;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PutResult;
import org.apache.arrow.flight.integration.tests.Scenarios;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.JsonFileReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Validator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntegrationTestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegrationTestClient.class);
    private final Options options = new Options();

    private IntegrationTestClient() {
        this.options.addOption("j", "json", true, "json file");
        this.options.addOption("scenario", true, "The integration test scenario.");
        this.options.addOption("host", true, "The host to connect to.");
        this.options.addOption("port", true, "The port to connect to.");
    }

    public static void main(String[] args) {
        try {
            new IntegrationTestClient().run(args);
        }
        catch (ParseException e) {
            IntegrationTestClient.fatalError("Invalid parameters", e);
        }
        catch (IOException e) {
            IntegrationTestClient.fatalError("Error accessing files", e);
        }
        catch (Exception e) {
            IntegrationTestClient.fatalError("Unknown error", e);
        }
    }

    private static void fatalError(String message, Throwable e) {
        System.err.println(message);
        System.err.println(e.getMessage());
        LOGGER.error(message, e);
        System.exit(1);
    }

    private void run(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(this.options, args, false);
        String host = cmd.getOptionValue("host", "localhost");
        int port = Integer.parseInt(cmd.getOptionValue("port", "31337"));
        Location defaultLocation = Location.forGrpcInsecure((String)host, (int)port);
        try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
             FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)defaultLocation).build();){
            if (cmd.hasOption("scenario")) {
                Scenarios.getScenario(cmd.getOptionValue("scenario")).client((BufferAllocator)allocator, defaultLocation, client);
            } else {
                String inputPath = cmd.getOptionValue("j");
                IntegrationTestClient.testStream((BufferAllocator)allocator, defaultLocation, client, inputPath);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testStream(BufferAllocator allocator, Location server, FlightClient client, String inputPath) throws IOException {
        FlightDescriptor descriptor = FlightDescriptor.path((String[])new String[]{inputPath});
        try (JsonFileReader reader = new JsonFileReader(new File(inputPath), allocator);
             VectorSchemaRoot root = VectorSchemaRoot.create((Schema)reader.start(), (BufferAllocator)allocator);){
            FlightClient.ClientStreamListener stream = client.startPut(descriptor, root, (DictionaryProvider)reader, (FlightClient.PutListener)new AsyncPutListener(){
                int counter = 0;

                public void onNext(PutResult val) {
                    byte[] metadataRaw = new byte[LargeMemoryUtil.checkedCastToInt((long)val.getApplicationMetadata().readableBytes())];
                    val.getApplicationMetadata().readBytes(metadataRaw);
                    String metadata = new String(metadataRaw, StandardCharsets.UTF_8);
                    if (!Integer.toString(this.counter).equals(metadata)) {
                        throw new RuntimeException(String.format("Invalid ACK from server. Expected '%d' but got '%s'.", this.counter, metadata));
                    }
                    ++this.counter;
                }
            }, new CallOption[0]);
            int counter = 0;
            while (reader.read(root)) {
                byte[] rawMetadata = Integer.toString(counter).getBytes(StandardCharsets.UTF_8);
                ArrowBuf metadata = allocator.buffer((long)rawMetadata.length);
                metadata.writeBytes(rawMetadata);
                stream.putNext(metadata);
                root.clear();
                ++counter;
            }
            stream.completed();
            stream.getResult();
        }
        FlightInfo info = client.getInfo(descriptor, new CallOption[0]);
        List endpoints = info.getEndpoints();
        if (endpoints.isEmpty()) {
            throw new RuntimeException("No endpoints returned from Flight server.");
        }
        Iterator iterator = info.getEndpoints().iterator();
        block48: while (iterator.hasNext()) {
            FlightEndpoint endpoint = (FlightEndpoint)iterator.next();
            List locations = endpoint.getLocations();
            if (locations.isEmpty()) {
                throw new RuntimeException("No locations returned from Flight server.");
            }
            Iterator iterator2 = locations.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block48;
                Location location = (Location)iterator2.next();
                System.out.println("Verifying location " + location.getUri());
                try {
                    FlightClient readClient = FlightClient.builder((BufferAllocator)allocator, (Location)location).build();
                    Throwable throwable = null;
                    try {
                        FlightStream stream = readClient.getStream(endpoint.getTicket(), new CallOption[0]);
                        Throwable throwable2 = null;
                        try {
                            VectorSchemaRoot root = stream.getRoot();
                            Throwable throwable3 = null;
                            try {
                                VectorSchemaRoot downloadedRoot = VectorSchemaRoot.create((Schema)root.getSchema(), (BufferAllocator)allocator);
                                Throwable throwable4 = null;
                                try (JsonFileReader reader = new JsonFileReader(new File(inputPath), allocator);){
                                    VectorLoader loader = new VectorLoader(downloadedRoot);
                                    VectorUnloader unloader = new VectorUnloader(root);
                                    Schema jsonSchema = reader.start();
                                    Validator.compareSchemas((Schema)root.getSchema(), (Schema)jsonSchema);
                                    VectorSchemaRoot jsonRoot = VectorSchemaRoot.create((Schema)jsonSchema, (BufferAllocator)allocator);
                                    Throwable throwable5 = null;
                                    try {
                                        while (stream.next()) {
                                            ArrowRecordBatch arb = unloader.getRecordBatch();
                                            Throwable throwable6 = null;
                                            try {
                                                loader.load(arb);
                                                if (reader.read(jsonRoot)) {
                                                    Validator.compareVectorSchemaRoot((VectorSchemaRoot)jsonRoot, (VectorSchemaRoot)downloadedRoot);
                                                    jsonRoot.clear();
                                                    continue;
                                                }
                                                throw new RuntimeException("Flight stream has more batches than JSON");
                                            }
                                            catch (Throwable throwable7) {
                                                throwable6 = throwable7;
                                                throw throwable7;
                                            }
                                            finally {
                                                if (arb == null) continue;
                                                IntegrationTestClient.$closeResource(throwable6, (AutoCloseable)arb);
                                            }
                                        }
                                        if (!reader.read(jsonRoot) || jsonRoot.getRowCount() <= 0) continue;
                                        throw new RuntimeException("JSON has more batches with than Flight stream");
                                    }
                                    catch (Throwable throwable8) {
                                        throwable5 = throwable8;
                                        throw throwable8;
                                    }
                                    finally {
                                        if (jsonRoot == null) continue;
                                        IntegrationTestClient.$closeResource(throwable5, (AutoCloseable)jsonRoot);
                                    }
                                }
                                catch (Throwable throwable9) {
                                    throwable4 = throwable9;
                                    throw throwable9;
                                }
                                finally {
                                    if (downloadedRoot == null) continue;
                                    IntegrationTestClient.$closeResource(throwable4, (AutoCloseable)downloadedRoot);
                                }
                            }
                            catch (Throwable throwable10) {
                                throwable3 = throwable10;
                                throw throwable10;
                            }
                            finally {
                                if (root == null) continue;
                                IntegrationTestClient.$closeResource(throwable3, (AutoCloseable)root);
                            }
                        }
                        catch (Throwable throwable11) {
                            throwable2 = throwable11;
                            throw throwable11;
                        }
                        finally {
                            if (stream == null) continue;
                            IntegrationTestClient.$closeResource(throwable2, (AutoCloseable)stream);
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (readClient == null) continue;
                        IntegrationTestClient.$closeResource(throwable, (AutoCloseable)readClient);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            break;
        }
        return;
    }
}

