/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.AllocationListener;

class TestBufferAllocationListener
implements AllocationListener {
    List<Entry> trail = new ArrayList<Entry>();

    TestBufferAllocationListener() {
    }

    public void onAllocation(long size) {
        this.trail.add(new Entry(Thread.currentThread().getStackTrace(), size, true));
    }

    public void onRelease(long size) {
        this.trail.add(new Entry(Thread.currentThread().getStackTrace(), size, false));
    }

    public void reThrowWithAddedAllocatorInfo(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        sb.append("\n");
        sb.append("[[Buffer allocation and release trail during the test execution: \n");
        for (Entry trailEntry : this.trail) {
            sb.append(String.format("%s: %d: %n%s", trailEntry.forAllocation ? "allocate" : "release", trailEntry.size, this.getStackTraceAsString(trailEntry.stackTrace)));
        }
        sb.append("]]");
        throw new IllegalStateException(sb.toString(), e);
    }

    private String getStackTraceAsString(StackTraceElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < elements.length; ++i) {
            StackTraceElement s = elements[i];
            sb.append("\t");
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    static class Entry {
        StackTraceElement[] stackTrace;
        long size;
        boolean forAllocation;

        public Entry(StackTraceElement[] stackTrace, long size, boolean forAllocation) {
            this.stackTrace = stackTrace;
            this.size = size;
            this.forAllocation = forAllocation;
        }
    }
}

