/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.FlightServerMiddleware;
import org.apache.arrow.flight.GetSessionOptionsRequest;
import org.apache.arrow.flight.GetSessionOptionsResult;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.ServerSessionMiddleware;
import org.apache.arrow.flight.SessionOptionValueFactory;
import org.apache.arrow.flight.SetSessionOptionsRequest;
import org.apache.arrow.flight.SetSessionOptionsResult;
import org.apache.arrow.flight.client.ClientCookieMiddleware;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.flight.integration.tests.SessionOptionsProducer;
import org.apache.arrow.flight.sql.FlightSqlClient;
import org.apache.arrow.memory.BufferAllocator;

final class SessionOptionsScenario
implements Scenario {
    private final FlightServerMiddleware.Key<ServerSessionMiddleware> key = FlightServerMiddleware.Key.of((String)"sessionmiddleware");

    SessionOptionsScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new SessionOptionsProducer(this.key);
    }

    @Override
    public void buildServer(FlightServer.Builder builder) {
        AtomicInteger counter = new AtomicInteger(1000);
        builder.middleware(this.key, (FlightServerMiddleware.Factory)new ServerSessionMiddleware.Factory(() -> String.valueOf(counter.getAndIncrement())));
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient ignored) throws Exception {
        ClientCookieMiddleware.Factory factory = new ClientCookieMiddleware.Factory();
        try (FlightClient flightClient = FlightClient.builder((BufferAllocator)allocator, (Location)location).intercept((FlightClientMiddleware.Factory)factory).build();){
            FlightSqlClient client = new FlightSqlClient(flightClient);
            SetSessionOptionsRequest req1 = new SetSessionOptionsRequest((Map)ImmutableMap.builder().put((Object)"foolong", (Object)SessionOptionValueFactory.makeSessionOptionValue((long)123L)).put((Object)"bardouble", (Object)SessionOptionValueFactory.makeSessionOptionValue((double)456.0)).put((Object)"lol_invalid", (Object)SessionOptionValueFactory.makeSessionOptionValue((String)"this won't get set")).put((Object)"key_with_invalid_value", (Object)SessionOptionValueFactory.makeSessionOptionValue((String)"lol_invalid")).put((Object)"big_ol_string_list", (Object)SessionOptionValueFactory.makeSessionOptionValue((String[])new String[]{"a", "b", "sea", "dee", " ", "  ", "geee", "(\u3065\uff61\u25d5\u203f\u203f\u25d5\uff61)\u3065"})).build());
            SetSessionOptionsResult res1 = client.setSessionOptions(req1, new CallOption[0]);
            IntegrationAssertions.assertEquals(ImmutableMap.builder().put((Object)"lol_invalid", (Object)new SetSessionOptionsResult.Error(SetSessionOptionsResult.ErrorValue.INVALID_NAME)).put((Object)"key_with_invalid_value", (Object)new SetSessionOptionsResult.Error(SetSessionOptionsResult.ErrorValue.INVALID_VALUE)).build(), res1.getErrors());
            GetSessionOptionsResult res2 = client.getSessionOptions(new GetSessionOptionsRequest(), new CallOption[0]);
            IntegrationAssertions.assertEquals(ImmutableMap.builder().put((Object)"foolong", (Object)SessionOptionValueFactory.makeSessionOptionValue((long)123L)).put((Object)"bardouble", (Object)SessionOptionValueFactory.makeSessionOptionValue((double)456.0)).put((Object)"big_ol_string_list", (Object)SessionOptionValueFactory.makeSessionOptionValue((String[])new String[]{"a", "b", "sea", "dee", " ", "  ", "geee", "(\u3065\uff61\u25d5\u203f\u203f\u25d5\uff61)\u3065"})).build(), res2.getSessionOptions());
            client.setSessionOptions(new SetSessionOptionsRequest((Map)ImmutableMap.builder().put((Object)"foolong", (Object)SessionOptionValueFactory.makeEmptySessionOptionValue()).put((Object)"big_ol_string_list", (Object)SessionOptionValueFactory.makeSessionOptionValue((String)"a,b,sea,dee, ,  ,geee,(\u3065\uff61\u25d5\u203f\u203f\u25d5\uff61)\u3065")).build()), new CallOption[0]);
            GetSessionOptionsResult res4 = client.getSessionOptions(new GetSessionOptionsRequest(), new CallOption[0]);
            IntegrationAssertions.assertEquals(ImmutableMap.builder().put((Object)"bardouble", (Object)SessionOptionValueFactory.makeSessionOptionValue((double)456.0)).put((Object)"big_ol_string_list", (Object)SessionOptionValueFactory.makeSessionOptionValue((String)"a,b,sea,dee, ,  ,geee,(\u3065\uff61\u25d5\u203f\u203f\u25d5\uff61)\u3065")).build(), res4.getSessionOptions());
        }
    }
}

