/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.PollInfo;
import org.apache.arrow.flight.integration.tests.IntegrationAssertions;
import org.apache.arrow.flight.integration.tests.PollFlightInfoProducer;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.memory.BufferAllocator;

final class PollFlightInfoScenario
implements Scenario {
    PollFlightInfoScenario() {
    }

    @Override
    public FlightProducer producer(BufferAllocator allocator, Location location) throws Exception {
        return new PollFlightInfoProducer();
    }

    @Override
    public void buildServer(FlightServer.Builder builder) throws Exception {
    }

    @Override
    public void client(BufferAllocator allocator, Location location, FlightClient client) throws Exception {
        PollInfo info = client.pollInfo(FlightDescriptor.command((byte[])"heavy query".getBytes(StandardCharsets.UTF_8)), new CallOption[0]);
        IntegrationAssertions.assertNotNull(info.getFlightInfo());
        Optional progress = info.getProgress();
        IntegrationAssertions.assertTrue("progress is missing", progress.isPresent());
        IntegrationAssertions.assertTrue("progress is invalid", (Double)progress.get() >= 0.0 && (Double)progress.get() <= 1.0);
        IntegrationAssertions.assertTrue("expiration is missing", info.getExpirationTime().isPresent());
        IntegrationAssertions.assertTrue("descriptor is missing", info.getFlightDescriptor().isPresent());
        info = client.pollInfo((FlightDescriptor)info.getFlightDescriptor().get(), new CallOption[0]);
        IntegrationAssertions.assertNotNull(info.getFlightInfo());
        progress = info.getProgress();
        IntegrationAssertions.assertTrue("progress is missing in finished query", progress.isPresent());
        IntegrationAssertions.assertTrue("progress isn't 1.0 in finished query", Math.abs((Double)progress.get() - 1.0) < Math.ulp(1.0));
        IntegrationAssertions.assertFalse("expiration is set in finished query", info.getExpirationTime().isPresent());
        IntegrationAssertions.assertFalse("descriptor is set in finished query", info.getFlightDescriptor().isPresent());
    }
}

