/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.FlightServer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.integration.tests.AppMetadataFlightInfoEndpointScenario;
import org.apache.arrow.flight.integration.tests.AuthBasicProtoScenario;
import org.apache.arrow.flight.integration.tests.ExpirationTimeCancelFlightInfoScenario;
import org.apache.arrow.flight.integration.tests.ExpirationTimeDoGetScenario;
import org.apache.arrow.flight.integration.tests.ExpirationTimeListActionsScenario;
import org.apache.arrow.flight.integration.tests.ExpirationTimeRenewFlightEndpointScenario;
import org.apache.arrow.flight.integration.tests.FlightSqlExtensionScenario;
import org.apache.arrow.flight.integration.tests.FlightSqlIngestionScenario;
import org.apache.arrow.flight.integration.tests.FlightSqlScenario;
import org.apache.arrow.flight.integration.tests.LocationReuseConnectionScenario;
import org.apache.arrow.flight.integration.tests.MiddlewareScenario;
import org.apache.arrow.flight.integration.tests.OrderedScenario;
import org.apache.arrow.flight.integration.tests.PollFlightInfoScenario;
import org.apache.arrow.flight.integration.tests.Scenario;
import org.apache.arrow.flight.integration.tests.SessionOptionsScenario;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;

final class Scenarios {
    private static Scenarios INSTANCE;
    private final Map<String, Supplier<Scenario>> scenarios = new TreeMap<String, Supplier<Scenario>>();

    private Scenarios() {
        this.scenarios.put("auth:basic_proto", AuthBasicProtoScenario::new);
        this.scenarios.put("expiration_time:cancel_flight_info", ExpirationTimeCancelFlightInfoScenario::new);
        this.scenarios.put("expiration_time:renew_flight_endpoint", ExpirationTimeRenewFlightEndpointScenario::new);
        this.scenarios.put("expiration_time:do_get", ExpirationTimeDoGetScenario::new);
        this.scenarios.put("expiration_time:list_actions", ExpirationTimeListActionsScenario::new);
        this.scenarios.put("location:reuse_connection", LocationReuseConnectionScenario::new);
        this.scenarios.put("middleware", MiddlewareScenario::new);
        this.scenarios.put("ordered", OrderedScenario::new);
        this.scenarios.put("poll_flight_info", PollFlightInfoScenario::new);
        this.scenarios.put("flight_sql", FlightSqlScenario::new);
        this.scenarios.put("flight_sql:extension", FlightSqlExtensionScenario::new);
        this.scenarios.put("flight_sql:ingestion", FlightSqlIngestionScenario::new);
        this.scenarios.put("app_metadata_flight_info_endpoint", AppMetadataFlightInfoEndpointScenario::new);
        this.scenarios.put("session_options", SessionOptionsScenario::new);
    }

    private static Scenarios getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Scenarios();
        }
        return INSTANCE;
    }

    static Scenario getScenario(String scenario) {
        Supplier<Scenario> ctor = Scenarios.getInstance().scenarios.get(scenario);
        if (ctor == null) {
            throw new IllegalArgumentException("Unknown integration test scenario: " + scenario);
        }
        return ctor.get();
    }

    public static void main(String[] args) {
        Location location = Location.forGrpcInsecure((String)"localhost", (int)31337);
        for (Map.Entry<String, Supplier<Scenario>> entry : Scenarios.getInstance().scenarios.entrySet()) {
            System.out.println("Running test scenario: " + entry.getKey());
            Scenario scenario = entry.getValue().get();
            try (RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);){
                FlightServer.Builder builder = FlightServer.builder((BufferAllocator)allocator, (Location)location, (FlightProducer)scenario.producer((BufferAllocator)allocator, location));
                scenario.buildServer(builder);
                FlightServer server = builder.build();
                try {
                    server.start();
                    try (FlightClient client = FlightClient.builder((BufferAllocator)allocator, (Location)location).build();){
                        scenario.client((BufferAllocator)allocator, location, client);
                    }
                    server.shutdown();
                    server.awaitTermination(1L, TimeUnit.SECONDS);
                    System.out.println("Ran scenario " + entry.getKey());
                }
                finally {
                    if (server == null) continue;
                    server.close();
                }
            }
            catch (Exception e) {
                System.out.println("Exception while running scenario " + entry.getKey());
                e.printStackTrace();
            }
        }
    }
}

