/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.integration.tests;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.flight.Action;
import org.apache.arrow.flight.ActionType;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.CancelFlightInfoRequest;
import org.apache.arrow.flight.CancelFlightInfoResult;
import org.apache.arrow.flight.CancelStatus;
import org.apache.arrow.flight.FlightConstants;
import org.apache.arrow.flight.FlightDescriptor;
import org.apache.arrow.flight.FlightEndpoint;
import org.apache.arrow.flight.FlightInfo;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.NoOpFlightProducer;
import org.apache.arrow.flight.RenewFlightEndpointRequest;
import org.apache.arrow.flight.Result;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;

final class ExpirationTimeProducer
extends NoOpFlightProducer {
    public static final Schema SCHEMA = new Schema(Collections.singletonList(Field.notNullable((String)"number", (ArrowType)Types.MinorType.UINT4.getType())));
    private final BufferAllocator allocator;
    private final List<EndpointStatus> statuses;

    ExpirationTimeProducer(BufferAllocator allocator) {
        this.allocator = allocator;
        this.statuses = new ArrayList<EndpointStatus>();
    }

    public FlightInfo getFlightInfo(FlightProducer.CallContext context, FlightDescriptor descriptor) {
        this.statuses.clear();
        ArrayList<FlightEndpoint> endpoints = new ArrayList<FlightEndpoint>();
        Instant now = Instant.now();
        endpoints.add(this.addEndpoint("No expiration time", null));
        endpoints.add(this.addEndpoint("5 seconds", now.plus(5L, ChronoUnit.SECONDS)));
        endpoints.add(this.addEndpoint("6 seconds", now.plus(6L, ChronoUnit.SECONDS)));
        return new FlightInfo(SCHEMA, descriptor, endpoints, -1L, -1L);
    }

    public void getStream(FlightProducer.CallContext context, Ticket ticket, FlightProducer.ServerStreamListener listener) {
        int index = this.parseIndexFromTicket(ticket);
        EndpointStatus status = this.statuses.get(index);
        if (status.cancelled) {
            listener.error((Throwable)CallStatus.NOT_FOUND.withDescription("Invalid flight: cancelled: " + new String(ticket.getBytes(), StandardCharsets.UTF_8)).toRuntimeException());
            return;
        }
        if (status.expirationTime != null && Instant.now().isAfter(status.expirationTime)) {
            listener.error((Throwable)CallStatus.NOT_FOUND.withDescription("Invalid flight: expired: " + new String(ticket.getBytes(), StandardCharsets.UTF_8)).toRuntimeException());
            return;
        }
        if (status.expirationTime == null && status.numGets > 0) {
            listener.error((Throwable)CallStatus.NOT_FOUND.withDescription("Invalid flight: can't read multiple times: " + new String(ticket.getBytes(), StandardCharsets.UTF_8)).toRuntimeException());
            return;
        }
        ++status.numGets;
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)SCHEMA, (BufferAllocator)this.allocator);){
            listener.start(root);
            UInt4Vector vector = (UInt4Vector)root.getVector(0);
            vector.setSafe(0, index);
            root.setRowCount(1);
            listener.putNext();
        }
        listener.completed();
    }

    public void doAction(FlightProducer.CallContext context, Action action, FlightProducer.StreamListener<Result> listener) {
        block7: {
            try {
                if (action.getType().equals(FlightConstants.CANCEL_FLIGHT_INFO.getType())) {
                    CancelFlightInfoRequest request = CancelFlightInfoRequest.deserialize((ByteBuffer)ByteBuffer.wrap(action.getBody()));
                    CancelStatus cancelStatus = CancelStatus.UNSPECIFIED;
                    for (FlightEndpoint endpoint : request.getInfo().getEndpoints()) {
                        int index = this.parseIndexFromTicket(endpoint.getTicket());
                        EndpointStatus status = this.statuses.get(index);
                        if (status.cancelled) {
                            cancelStatus = CancelStatus.NOT_CANCELLABLE;
                            continue;
                        }
                        status.cancelled = true;
                        if (cancelStatus != CancelStatus.UNSPECIFIED) continue;
                        cancelStatus = CancelStatus.CANCELLED;
                    }
                    listener.onNext((Object)new Result(new CancelFlightInfoResult(cancelStatus).serialize().array()));
                    break block7;
                }
                if (action.getType().equals(FlightConstants.RENEW_FLIGHT_ENDPOINT.getType())) {
                    Instant expiration;
                    RenewFlightEndpointRequest request = RenewFlightEndpointRequest.deserialize((ByteBuffer)ByteBuffer.wrap(action.getBody()));
                    FlightEndpoint endpoint = request.getFlightEndpoint();
                    int index = this.parseIndexFromTicket(endpoint.getTicket());
                    EndpointStatus status = this.statuses.get(index);
                    if (status.cancelled) {
                        listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Invalid flight: cancelled: " + index).toRuntimeException());
                        return;
                    }
                    String ticketBody = new String(endpoint.getTicket().getBytes(), StandardCharsets.UTF_8);
                    ticketBody = ticketBody + ": renewed (+ 10 seconds)";
                    Ticket ticket = new Ticket(ticketBody.getBytes(StandardCharsets.UTF_8));
                    status.expirationTime = expiration = Instant.now().plus(10L, ChronoUnit.SECONDS);
                    FlightEndpoint newEndpoint = new FlightEndpoint(ticket, expiration, endpoint.getLocations().toArray(new Location[0]));
                    listener.onNext((Object)new Result(newEndpoint.serialize().array()));
                    break block7;
                }
                listener.onError((Throwable)CallStatus.INVALID_ARGUMENT.withDescription("Unknown action: " + action.getType()).toRuntimeException());
                return;
            }
            catch (IOException | URISyntaxException e) {
                listener.onError((Throwable)CallStatus.INTERNAL.withCause((Throwable)e).withDescription(e.toString()).toRuntimeException());
                return;
            }
        }
        listener.onCompleted();
    }

    public void listActions(FlightProducer.CallContext context, FlightProducer.StreamListener<ActionType> listener) {
        listener.onNext((Object)FlightConstants.CANCEL_FLIGHT_INFO);
        listener.onNext((Object)FlightConstants.RENEW_FLIGHT_ENDPOINT);
        listener.onCompleted();
    }

    private FlightEndpoint addEndpoint(String ticket, Instant expirationTime) {
        Ticket flightTicket = new Ticket(String.format("%d: %s", this.statuses.size(), ticket).getBytes(StandardCharsets.UTF_8));
        this.statuses.add(new EndpointStatus(expirationTime));
        return new FlightEndpoint(flightTicket, expirationTime, new Location[0]);
    }

    private int parseIndexFromTicket(Ticket ticket) {
        String contents = new String(ticket.getBytes(), StandardCharsets.UTF_8);
        int index = contents.indexOf(58);
        if (index == -1) {
            throw CallStatus.INVALID_ARGUMENT.withDescription("Invalid ticket: " + new String(ticket.getBytes(), StandardCharsets.UTF_8)).toRuntimeException();
        }
        int endpointIndex = Integer.parseInt(contents.substring(0, index));
        if (endpointIndex < 0 || endpointIndex >= this.statuses.size()) {
            throw CallStatus.NOT_FOUND.withDescription("Out of bounds").toRuntimeException();
        }
        return endpointIndex;
    }

    static final class EndpointStatus {
        Instant expirationTime;
        int numGets;
        boolean cancelled;

        EndpointStatus(Instant expirationTime) {
            this.expirationTime = expirationTime;
            this.numGets = 0;
            this.cancelled = false;
        }
    }
}

