/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.ipc.ArrowFileWriter;
import org.apache.arrow.vector.ipc.ArrowStreamReader;

public class StreamToFile {
    public static void convert(InputStream in, OutputStream out) throws IOException {
        RootAllocator allocator = new RootAllocator(Integer.MAX_VALUE);
        try (ArrowStreamReader reader = new ArrowStreamReader(in, (BufferAllocator)allocator);){
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            if (!reader.loadNextBatch()) {
                throw new IOException("Unable to read first record batch");
            }
            try (ArrowFileWriter writer = new ArrowFileWriter(root, (DictionaryProvider)reader, Channels.newChannel(out));){
                writer.start();
                do {
                    writer.writeBatch();
                } while (reader.loadNextBatch());
                writer.end();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        InputStream in = System.in;
        OutputStream out = System.out;
        if (args.length == 2) {
            in = new FileInputStream(new File(args[0]));
            out = new FileOutputStream(new File(args[1]));
        }
        StreamToFile.convert(in, out);
    }
}

