/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.util;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.util.TransferPair;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class TransferPairBenchmarks {
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private IntVector intVector;
    private VarCharVector varCharVector;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.intVector = new IntVector("intVector", this.allocator);
        this.varCharVector = new VarCharVector("varcharVector", this.allocator);
        this.intVector.allocateNew(1024);
        this.varCharVector.allocateNew(1024);
        for (int i = 0; i < 1024; ++i) {
            if (i % 3 == 0) {
                this.intVector.setNull(i);
                this.varCharVector.setNull(i);
                continue;
            }
            this.intVector.setSafe(i, i * i);
            this.varCharVector.setSafe(i, ("teststring" + i).getBytes(StandardCharsets.UTF_8));
        }
        this.intVector.setValueCount(1024);
        this.varCharVector.setValueCount(1024);
    }

    @TearDown
    public void tearDown() {
        this.intVector.close();
        this.varCharVector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public int splitAndTransferIntVector() {
        IntVector toVector = new IntVector("intVector", this.allocator);
        toVector.setValueCount(1024);
        TransferPair transferPair = this.intVector.makeTransferPair((ValueVector)toVector);
        transferPair.splitAndTransfer(0, 1024);
        toVector.close();
        return 0;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public int splitAndTransferVarcharVector() {
        VarCharVector toVector = new VarCharVector("varcharVector", this.allocator);
        toVector.setValueCount(1024);
        TransferPair transferPair = this.varCharVector.makeTransferPair((ValueVector)toVector);
        transferPair.splitAndTransfer(0, 1024);
        toVector.close();
        return 0;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(TransferPairBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

