/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class WriteChannelBenchmark {
    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void alignBenchmark(AlignState state) throws IOException {
        state.writeChannel.align();
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(WriteChannelBenchmark.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Benchmark)
    public static class AlignState {
        private ByteArrayOutputStream baos;
        private WriteChannel writeChannel;
        @Param(value={"1", "2", "3", "4", "5", "6", "7"})
        public int alignSize;

        @Setup(value=Level.Invocation)
        public void prepareInvoke() throws IOException {
            this.baos = new ByteArrayOutputStream(8);
            this.writeChannel = new WriteChannel(Channels.newChannel(this.baos));
            this.writeChannel.write(new byte[8 - this.alignSize]);
        }

        @TearDown(value=Level.Invocation)
        public void tearDownInvoke() throws IOException {
            this.writeChannel.close();
            this.baos.close();
        }
    }
}

