/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.compare.ApproxEqualsVisitor;
import org.apache.arrow.vector.compare.Range;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class FloatingPointBenchmarks {
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private Float4Vector floatVector1;
    private Float4Vector floatVector2;
    private Float8Vector doubleVector1;
    private Float8Vector doubleVector2;
    private ApproxEqualsVisitor floatVisitor;
    private ApproxEqualsVisitor doubleVisitor;
    private Range range;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.floatVector1 = new Float4Vector("vector", this.allocator);
        this.floatVector2 = new Float4Vector("vector", this.allocator);
        this.doubleVector1 = new Float8Vector("vector", this.allocator);
        this.doubleVector2 = new Float8Vector("vector", this.allocator);
        this.floatVector1.allocateNew(1024);
        this.floatVector2.allocateNew(1024);
        this.doubleVector1.allocateNew(1024);
        this.doubleVector2.allocateNew(1024);
        for (int i = 0; i < 1024; ++i) {
            if (i % 3 == 0) {
                this.floatVector1.setNull(i);
                this.floatVector2.setNull(i);
                this.doubleVector1.setNull(i);
                this.doubleVector2.setNull(i);
                continue;
            }
            this.floatVector1.set(i, (float)(i * i));
            this.floatVector2.set(i, (float)(i * i));
            this.doubleVector1.set(i, (double)(i * i));
            this.doubleVector2.set(i, (double)(i * i));
        }
        this.floatVector1.setValueCount(1024);
        this.floatVector2.setValueCount(1024);
        this.doubleVector1.setValueCount(1024);
        this.doubleVector2.setValueCount(1024);
        this.floatVisitor = new ApproxEqualsVisitor((ValueVector)this.floatVector1, (ValueVector)this.floatVector2, 0.01f, 0.01);
        this.doubleVisitor = new ApproxEqualsVisitor((ValueVector)this.doubleVector1, (ValueVector)this.doubleVector2, 0.01f, 0.01);
        this.range = new Range(0, 0, 1024);
    }

    @TearDown
    public void tearDown() {
        this.floatVector1.close();
        this.floatVector2.close();
        this.doubleVector1.close();
        this.doubleVector2.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public int approxEqualsBenchmark() {
        boolean floatResult = this.floatVisitor.visit((BaseFixedWidthVector)this.floatVector1, this.range);
        boolean doubleResult = this.doubleVisitor.visit((BaseFixedWidthVector)this.doubleVector1, this.range);
        return (floatResult ? 1 : 0) + (doubleResult ? 1 : 0);
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(FloatingPointBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

