/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.util;

import io.netty.buffer.ArrowBuf;
import io.netty.util.internal.PlatformDependent;
import org.apache.arrow.memory.BoundsChecking;
import org.apache.arrow.memory.util.hash.SimpleHasher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteFunctionHelpers {
    static final Logger logger = LoggerFactory.getLogger(ByteFunctionHelpers.class);

    private ByteFunctionHelpers() {
    }

    public static final int equal(ArrowBuf left, int lStart, int lEnd, ArrowBuf right, int rStart, int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memEqual(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static int memEqual(long laddr, int lStart, int lEnd, long raddr, int rStart, int rEnd) {
        int n = lEnd - lStart;
        if (n == rEnd - rStart) {
            long lPos = laddr + (long)lStart;
            long rPos = raddr + (long)rStart;
            while (n > 7) {
                long rightLong;
                long leftLong = PlatformDependent.getLong((long)lPos);
                if (leftLong != (rightLong = PlatformDependent.getLong((long)rPos))) {
                    return 0;
                }
                lPos += 8L;
                rPos += 8L;
                n -= 8;
            }
            while (n > 3) {
                int rightInt;
                int leftInt = PlatformDependent.getInt((long)lPos);
                if (leftInt != (rightInt = PlatformDependent.getInt((long)rPos))) {
                    return 0;
                }
                lPos += 4L;
                rPos += 4L;
                n -= 4;
            }
            while (n-- != 0) {
                byte rightByte;
                byte leftByte = PlatformDependent.getByte((long)lPos);
                if (leftByte != (rightByte = PlatformDependent.getByte((long)rPos))) {
                    return 0;
                }
                ++lPos;
                ++rPos;
            }
            return 1;
        }
        return 0;
    }

    public static final int compare(ArrowBuf left, int lStart, int lEnd, ArrowBuf right, int rStart, int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
            right.checkBytes(rStart, rEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right.memoryAddress(), rStart, rEnd);
    }

    private static int memcmp(long laddr, int lStart, int lEnd, long raddr, int rStart, int rEnd) {
        int n;
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        long lPos = laddr + (long)lStart;
        long rPos = raddr + (long)rStart;
        for (n = Math.min(rLen, lLen); n > 7; n -= 8) {
            long rightLong;
            long leftLong = PlatformDependent.getLong((long)lPos);
            if (leftLong != (rightLong = PlatformDependent.getLong((long)rPos))) {
                return ByteFunctionHelpers.unsignedLongCompare(Long.reverseBytes(leftLong), Long.reverseBytes(rightLong));
            }
            lPos += 8L;
            rPos += 8L;
        }
        while (n > 3) {
            int rightInt;
            int leftInt = PlatformDependent.getInt((long)lPos);
            if (leftInt != (rightInt = PlatformDependent.getInt((long)rPos))) {
                return ByteFunctionHelpers.unsignedIntCompare(Integer.reverseBytes(leftInt), Integer.reverseBytes(rightInt));
            }
            lPos += 4L;
            rPos += 4L;
            n -= 4;
        }
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = PlatformDependent.getByte((long)lPos);
            if (leftByte != (rightByte = PlatformDependent.getByte((long)rPos))) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static final int compare(ArrowBuf left, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            left.checkBytes(lStart, lEnd);
        }
        return ByteFunctionHelpers.memcmp(left.memoryAddress(), lStart, lEnd, right, rStart, rEnd);
    }

    public static int unsignedLongCompare(long a, long b) {
        return Long.compare(a ^ Long.MIN_VALUE, b ^ Long.MIN_VALUE);
    }

    public static int unsignedIntCompare(int a, int b) {
        return Integer.compare(a ^ Integer.MIN_VALUE, b ^ Integer.MIN_VALUE);
    }

    private static int memcmp(long laddr, int lStart, int lEnd, byte[] right, int rStart, int rEnd) {
        int lLen = lEnd - lStart;
        int rLen = rEnd - rStart;
        int n = Math.min(rLen, lLen);
        long lPos = laddr + (long)lStart;
        int rPos = rStart;
        while (n-- != 0) {
            byte rightByte;
            byte leftByte = PlatformDependent.getByte((long)lPos);
            if (leftByte != (rightByte = right[rPos])) {
                return (leftByte & 0xFF) - (rightByte & 0xFF) > 0 ? 1 : -1;
            }
            ++lPos;
            ++rPos;
        }
        if (lLen == rLen) {
            return 0;
        }
        return lLen > rLen ? 1 : -1;
    }

    public static final int hash(ArrowBuf buf, int start, int end) {
        SimpleHasher hasher = SimpleHasher.INSTANCE;
        return hasher.hashCode(buf, start, end - start);
    }

    public static int combineHash(int currentHash, int newHash) {
        return currentHash * 31 + newHash;
    }
}

