/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import io.netty.buffer.PooledByteBufAllocatorL;
import io.netty.buffer.UnsafeDirectLittleEndian;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferLedger;
import org.apache.arrow.memory.LowCostIdentityHashMap;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;

public class AllocationManager {
    private static final AtomicLong MANAGER_ID_GENERATOR = new AtomicLong(0L);
    private static final PooledByteBufAllocatorL INNER_ALLOCATOR = new PooledByteBufAllocatorL();
    static final UnsafeDirectLittleEndian EMPTY = AllocationManager.INNER_ALLOCATOR.empty;
    static final long CHUNK_SIZE = INNER_ALLOCATOR.getChunkSize();
    private final RootAllocator root;
    private final long allocatorManagerId = MANAGER_ID_GENERATOR.incrementAndGet();
    private final int size;
    private final UnsafeDirectLittleEndian memoryChunk;
    private final LowCostIdentityHashMap<BaseAllocator, BufferLedger> map = new LowCostIdentityHashMap();
    private final long amCreationTime = System.nanoTime();
    private volatile BufferLedger owningLedger;
    private volatile long amDestructionTime = 0L;

    AllocationManager(BaseAllocator accountingAllocator, int size) {
        Preconditions.checkNotNull(accountingAllocator);
        accountingAllocator.assertOpen();
        this.root = accountingAllocator.root;
        this.memoryChunk = INNER_ALLOCATOR.allocate(size);
        this.owningLedger = this.associate(accountingAllocator, false);
        this.size = this.memoryChunk.capacity();
    }

    BufferLedger getOwningLedger() {
        return this.owningLedger;
    }

    void setOwningLedger(BufferLedger ledger) {
        this.owningLedger = ledger;
    }

    UnsafeDirectLittleEndian getMemoryChunk() {
        return this.memoryChunk;
    }

    BufferLedger associate(BaseAllocator allocator) {
        return this.associate(allocator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferLedger associate(BaseAllocator allocator, boolean retain) {
        allocator.assertOpen();
        Preconditions.checkState(this.root == allocator.root, "A buffer can only be associated between two allocators that share the same root");
        AllocationManager allocationManager = this;
        synchronized (allocationManager) {
            BufferLedger oldLedger;
            BufferLedger ledger = this.map.get(allocator);
            if (ledger != null) {
                if (retain) {
                    ledger.increment();
                }
                return ledger;
            }
            ledger = new BufferLedger(allocator, this);
            if (retain) {
                ledger.increment();
            }
            Preconditions.checkState((oldLedger = this.map.put(ledger)) == null, "Detected inconsitent state: A reference manager already exists for this allocator");
            allocator.associateLedger(ledger);
            return ledger;
        }
    }

    void release(BufferLedger ledger) {
        BaseAllocator allocator = (BaseAllocator)ledger.getAllocator();
        allocator.assertOpen();
        Preconditions.checkState(this.map.containsKey(allocator), "Expecting a mapping for allocator and reference manager");
        BufferLedger oldLedger = this.map.remove(allocator);
        ((BaseAllocator)oldLedger.getAllocator()).dissociateLedger(oldLedger);
        if (oldLedger == this.owningLedger) {
            if (this.map.isEmpty()) {
                ((BaseAllocator)oldLedger.getAllocator()).releaseBytes(this.size);
                this.memoryChunk.release();
                ((BaseAllocator)oldLedger.getAllocator()).getListener().onRelease(this.size);
                this.amDestructionTime = System.nanoTime();
                this.owningLedger = null;
            } else {
                BufferLedger newOwningLedger = this.map.getNextValue();
                oldLedger.transferBalance(newOwningLedger);
            }
        } else {
            Preconditions.checkState(this.map.size() > 0, "The final removal of reference manager should be connected to owning reference manager");
        }
    }

    public int getSize() {
        return this.size;
    }
}

