/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.MemoryUtil;

public final class UnsafeAllocationManager
extends AllocationManager {
    private static final ArrowBuf EMPTY = new ArrowBuf(ReferenceManager.NO_OP, null, 0L, MemoryUtil.UNSAFE.allocateMemory(0L));
    public static final AllocationManager.Factory FACTORY = new AllocationManager.Factory(){

        public AllocationManager create(BaseAllocator accountingAllocator, long size) {
            return new UnsafeAllocationManager(accountingAllocator, size);
        }

        public ArrowBuf empty() {
            return EMPTY;
        }
    };
    private final long allocatedSize;
    private final long allocatedAddress;

    UnsafeAllocationManager(BaseAllocator accountingAllocator, long requestedSize) {
        super(accountingAllocator);
        this.allocatedAddress = MemoryUtil.UNSAFE.allocateMemory(requestedSize);
        this.allocatedSize = requestedSize;
    }

    public long getSize() {
        return this.allocatedSize;
    }

    protected long memoryAddress() {
        return this.allocatedAddress;
    }

    protected void release0() {
        MemoryUtil.UNSAFE.freeMemory(this.allocatedAddress);
    }
}

