/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.VarBinaryVector;

public abstract class BinaryConsumer
extends BaseConsumer<VarBinaryVector> {
    private final byte[] reuseBytes = new byte[1024];

    public static BinaryConsumer createConsumer(VarBinaryVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableBinaryConsumer(vector, index);
        }
        return new NonNullableBinaryConsumer(vector, index);
    }

    public BinaryConsumer(VarBinaryVector vector, int index) {
        super(vector, index);
        if (vector != null) {
            vector.allocateNewSafe();
        }
    }

    public void consume(InputStream is) throws IOException {
        while (this.currentIndex >= ((VarBinaryVector)this.vector).getValueCapacity()) {
            ((VarBinaryVector)this.vector).reallocValidityAndOffsetBuffers();
        }
        int startOffset = ((VarBinaryVector)this.vector).getStartOffset(this.currentIndex);
        ArrowBuf offsetBuffer = ((VarBinaryVector)this.vector).getOffsetBuffer();
        int dataLength = 0;
        if (is != null) {
            int read;
            while ((read = is.read(this.reuseBytes)) != -1) {
                while (((VarBinaryVector)this.vector).getDataBuffer().capacity() < (long)(startOffset + dataLength + read)) {
                    ((VarBinaryVector)this.vector).reallocDataBuffer();
                }
                ((VarBinaryVector)this.vector).getDataBuffer().setBytes((long)(startOffset + dataLength), this.reuseBytes, 0, (long)read);
                dataLength += read;
            }
            BitVectorHelper.setBit((ArrowBuf)((VarBinaryVector)this.vector).getValidityBuffer(), (long)this.currentIndex);
        }
        offsetBuffer.setInt((long)(this.currentIndex + 1) * 4L, startOffset + dataLength);
        ((VarBinaryVector)this.vector).setLastSet(this.currentIndex);
    }

    public void moveWriterPosition() {
        ++this.currentIndex;
    }

    @Override
    public void resetValueVector(VarBinaryVector vector) {
        this.vector = vector;
        ((VarBinaryVector)this.vector).allocateNewSafe();
        this.currentIndex = 0;
    }

    static class NullableBinaryConsumer
    extends BinaryConsumer {
        public NullableBinaryConsumer(VarBinaryVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException, IOException {
            InputStream is = resultSet.getBinaryStream(this.columnIndexInResultSet);
            this.consume(is);
            this.moveWriterPosition();
        }
    }

    static class NonNullableBinaryConsumer
    extends BinaryConsumer {
        public NonNullableBinaryConsumer(VarBinaryVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException, IOException {
            InputStream is = resultSet.getBinaryStream(this.columnIndexInResultSet);
            this.consume(is);
            this.moveWriterPosition();
        }
    }
}

