/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class TimeStampBinder
extends BaseColumnBinder<TimeStampVector> {
    private final Calendar calendar;
    private final long unitsPerSecond;
    private final long nanosPerUnit;

    public TimeStampBinder(TimeStampVector vector, Calendar calendar) {
        this(vector, calendar, TimeStampBinder.isZoned(vector.getField().getType()) ? 2014 : 93);
    }

    public TimeStampBinder(TimeStampVector vector, Calendar calendar, int jdbcType) {
        super(vector, jdbcType);
        this.calendar = calendar;
        ArrowType.Timestamp type = (ArrowType.Timestamp)vector.getField().getType();
        switch (type.getUnit()) {
            case SECOND: {
                this.unitsPerSecond = 1L;
                this.nanosPerUnit = 1000000000L;
                break;
            }
            case MILLISECOND: {
                this.unitsPerSecond = 1000L;
                this.nanosPerUnit = 1000000L;
                break;
            }
            case MICROSECOND: {
                this.unitsPerSecond = 1000000L;
                this.nanosPerUnit = 1000L;
                break;
            }
            case NANOSECOND: {
                this.unitsPerSecond = 1000000000L;
                this.nanosPerUnit = 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid time unit in " + String.valueOf(type));
            }
        }
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        long rawValue = ((TimeStampVector)this.vector).getDataBuffer().getLong((long)rowIndex * 8L);
        long seconds = rawValue / this.unitsPerSecond;
        int nanos = (int)((rawValue - seconds * this.unitsPerSecond) * this.nanosPerUnit);
        Timestamp value = new Timestamp(seconds * 1000L);
        value.setNanos(nanos);
        if (this.calendar != null) {
            statement.setTimestamp(parameterIndex, value, this.calendar);
        } else {
            statement.setTimestamp(parameterIndex, value);
        }
    }

    private static boolean isZoned(ArrowType type) {
        String timezone = ((ArrowType.Timestamp)type).getTimezone();
        return timezone != null && !timezone.isEmpty();
    }
}

