/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.VarCharVector;

public abstract class VarCharConsumer {
    public static JdbcConsumer<VarCharVector> createConsumer(VarCharVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableVarCharConsumer(vector, index);
        }
        return new NonNullableVarCharConsumer(vector, index);
    }

    static class NullableVarCharConsumer
    extends BaseConsumer<VarCharVector> {
        public NullableVarCharConsumer(VarCharVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            String value = resultSet.getString(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
                ((VarCharVector)this.vector).setSafe(this.currentIndex, bytes);
            }
            ++this.currentIndex;
        }
    }

    static class NonNullableVarCharConsumer
    extends BaseConsumer<VarCharVector> {
        public NonNullableVarCharConsumer(VarCharVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            String value = resultSet.getString(this.columnIndexInResultSet);
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            ((VarCharVector)this.vector).setSafe(this.currentIndex, bytes);
            ++this.currentIndex;
        }
    }
}

