/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.Decimal256Vector;

public abstract class Decimal256Consumer
extends BaseConsumer<Decimal256Vector> {
    private final RoundingMode bigDecimalRoundingMode;
    private final int scale;

    public Decimal256Consumer(Decimal256Vector vector, int index) {
        this(vector, index, null);
    }

    public Decimal256Consumer(Decimal256Vector vector, int index, RoundingMode bigDecimalRoundingMode) {
        super(vector, index);
        this.bigDecimalRoundingMode = bigDecimalRoundingMode;
        this.scale = vector.getScale();
    }

    public static JdbcConsumer<Decimal256Vector> createConsumer(Decimal256Vector vector, int index, boolean nullable, RoundingMode bigDecimalRoundingMode) {
        if (nullable) {
            return new NullableDecimal256Consumer(vector, index, bigDecimalRoundingMode);
        }
        return new NonNullableDecimal256Consumer(vector, index, bigDecimalRoundingMode);
    }

    protected void set(BigDecimal value) {
        if (this.bigDecimalRoundingMode != null && value.scale() != this.scale) {
            value = value.setScale(this.scale, this.bigDecimalRoundingMode);
        }
        ((Decimal256Vector)this.vector).set(this.currentIndex, value);
    }

    static class NullableDecimal256Consumer
    extends Decimal256Consumer {
        public NullableDecimal256Consumer(Decimal256Vector vector, int index, RoundingMode bigDecimalRoundingMode) {
            super(vector, index, bigDecimalRoundingMode);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            BigDecimal value = resultSet.getBigDecimal(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                this.set(value);
            }
            ++this.currentIndex;
        }
    }

    static class NonNullableDecimal256Consumer
    extends Decimal256Consumer {
        public NonNullableDecimal256Consumer(Decimal256Vector vector, int index, RoundingMode bigDecimalRoundingMode) {
            super(vector, index, bigDecimalRoundingMode);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            BigDecimal value = resultSet.getBigDecimal(this.columnIndexInResultSet);
            this.set(value);
            ++this.currentIndex;
        }
    }
}

