/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.adapter.jdbc.consumer.CompositeJdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.exceptions.JdbcConsumerException;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ValueVectorUtility;

public class ArrowVectorIterator
implements Iterator<VectorSchemaRoot>,
AutoCloseable {
    private final ResultSet resultSet;
    private final JdbcToArrowConfig config;
    private final Schema schema;
    private final ResultSetMetaData rsmd;
    private final JdbcConsumer[] consumers;
    final CompositeJdbcConsumer compositeConsumer;
    private VectorSchemaRoot nextBatch;
    private final int targetBatchSize;
    private boolean readComplete = false;

    private ArrowVectorIterator(ResultSet resultSet, JdbcToArrowConfig config) throws SQLException {
        this.resultSet = resultSet;
        this.config = config;
        this.schema = JdbcToArrowUtils.jdbcToArrowSchema(resultSet.getMetaData(), config);
        this.targetBatchSize = config.getTargetBatchSize();
        this.rsmd = resultSet.getMetaData();
        this.consumers = new JdbcConsumer[this.rsmd.getColumnCount()];
        this.compositeConsumer = new CompositeJdbcConsumer(this.consumers);
        this.nextBatch = config.isReuseVectorSchemaRoot() ? this.createVectorSchemaRoot() : null;
    }

    public static ArrowVectorIterator create(ResultSet resultSet, JdbcToArrowConfig config) throws SQLException {
        ArrowVectorIterator iterator = null;
        try {
            iterator = new ArrowVectorIterator(resultSet, config);
        }
        catch (Throwable e) {
            AutoCloseables.close((Throwable)e, (AutoCloseable[])new AutoCloseable[]{iterator});
            throw new RuntimeException("Error occurred while creating iterator.", e);
        }
        return iterator;
    }

    private void consumeData(VectorSchemaRoot root) {
        try {
            int readRowCount = 0;
            if (this.targetBatchSize == -1) {
                while (this.resultSet.next()) {
                    ValueVectorUtility.ensureCapacity((VectorSchemaRoot)root, (int)(readRowCount + 1));
                    this.compositeConsumer.consume(this.resultSet);
                    ++readRowCount;
                }
                this.readComplete = true;
            } else {
                while (readRowCount < this.targetBatchSize && !this.readComplete) {
                    if (this.resultSet.next()) {
                        this.compositeConsumer.consume(this.resultSet);
                        ++readRowCount;
                        continue;
                    }
                    this.readComplete = true;
                }
            }
            root.setRowCount(readRowCount);
        }
        catch (Throwable e) {
            this.compositeConsumer.close();
            if (e instanceof JdbcConsumerException) {
                throw (JdbcConsumerException)e;
            }
            throw new RuntimeException("Error occurred while consuming data.", e);
        }
    }

    private VectorSchemaRoot createVectorSchemaRoot() throws SQLException {
        VectorSchemaRoot root = null;
        try {
            root = VectorSchemaRoot.create((Schema)this.schema, (BufferAllocator)this.config.getAllocator());
            if (this.config.getTargetBatchSize() != -1) {
                ValueVectorUtility.preAllocate((VectorSchemaRoot)root, (int)this.config.getTargetBatchSize());
            }
        }
        catch (Throwable e) {
            if (root != null) {
                root.close();
            }
            throw new RuntimeException("Error occurred while creating schema root.", e);
        }
        this.initialize(root);
        return root;
    }

    private void initialize(VectorSchemaRoot root) throws SQLException {
        for (int i = 1; i <= this.consumers.length; ++i) {
            JdbcFieldInfo columnFieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForColumn(this.rsmd, i, this.config);
            ArrowType arrowType = this.config.getJdbcToArrowTypeConverter().apply(columnFieldInfo);
            this.consumers[i - 1] = this.config.getJdbcConsumerGetter().apply(arrowType, i, JdbcToArrowUtils.isColumnNullable(this.resultSet.getMetaData(), i, columnFieldInfo), root.getVector(i - 1), this.config);
        }
    }

    private void load(VectorSchemaRoot root) {
        for (int i = 0; i < this.consumers.length; ++i) {
            FieldVector vec = root.getVector(i);
            if (this.config.isReuseVectorSchemaRoot()) {
                vec.reset();
            }
            this.consumers[i].resetValueVector(vec);
        }
        this.consumeData(root);
    }

    @Override
    public boolean hasNext() {
        return !this.readComplete;
    }

    @Override
    public VectorSchemaRoot next() {
        Preconditions.checkArgument((boolean)this.hasNext());
        try {
            VectorSchemaRoot ret = this.config.isReuseVectorSchemaRoot() ? this.nextBatch : this.createVectorSchemaRoot();
            this.load(ret);
            return ret;
        }
        catch (Exception e) {
            this.close();
            if (e instanceof JdbcConsumerException) {
                throw (JdbcConsumerException)e;
            }
            throw new RuntimeException("Error occurred while getting next schema root.", e);
        }
    }

    @Override
    public void close() {
        if (this.config.isReuseVectorSchemaRoot()) {
            this.nextBatch.close();
            this.compositeConsumer.close();
        }
    }
}

