/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.DecimalVector;

public abstract class DecimalConsumer
extends BaseConsumer<DecimalVector> {
    private final RoundingMode bigDecimalRoundingMode;
    private final int scale;

    public DecimalConsumer(DecimalVector vector, int index) {
        this(vector, index, null);
    }

    public DecimalConsumer(DecimalVector vector, int index, RoundingMode bigDecimalRoundingMode) {
        super(vector, index);
        this.bigDecimalRoundingMode = bigDecimalRoundingMode;
        this.scale = vector.getScale();
    }

    public static JdbcConsumer<DecimalVector> createConsumer(DecimalVector vector, int index, boolean nullable, RoundingMode bigDecimalRoundingMode) {
        if (nullable) {
            return new NullableDecimalConsumer(vector, index, bigDecimalRoundingMode);
        }
        return new NonNullableDecimalConsumer(vector, index, bigDecimalRoundingMode);
    }

    protected void set(BigDecimal value) {
        if (this.bigDecimalRoundingMode != null && value.scale() != this.scale) {
            value = value.setScale(this.scale, this.bigDecimalRoundingMode);
        }
        ((DecimalVector)this.vector).set(this.currentIndex, value);
    }

    static class NonNullableDecimalConsumer
    extends DecimalConsumer {
        public NonNullableDecimalConsumer(DecimalVector vector, int index, RoundingMode bigDecimalRoundingMode) {
            super(vector, index, bigDecimalRoundingMode);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            BigDecimal value = resultSet.getBigDecimal(this.columnIndexInResultSet);
            this.set(value);
            ++this.currentIndex;
        }
    }

    static class NullableDecimalConsumer
    extends DecimalConsumer {
        public NullableDecimalConsumer(DecimalVector vector, int index, RoundingMode bigDecimalRoundingMode) {
            super(vector, index, bigDecimalRoundingMode);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            BigDecimal value = resultSet.getBigDecimal(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                this.set(value);
            }
            ++this.currentIndex;
        }
    }
}

