/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.DateMilliVector;

public class DateMilliBinder
extends BaseColumnBinder<DateMilliVector> {
    private final Calendar calendar;

    public DateMilliBinder(DateMilliVector vector) {
        this(vector, null, 91);
    }

    public DateMilliBinder(DateMilliVector vector, Calendar calendar) {
        this(vector, calendar, 91);
    }

    public DateMilliBinder(DateMilliVector vector, Calendar calendar, int jdbcType) {
        super(vector, jdbcType);
        this.calendar = calendar;
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        long index = (long)rowIndex * 8L;
        Date value = new Date(((DateMilliVector)this.vector).getDataBuffer().getLong(index));
        if (this.calendar == null) {
            statement.setDate(parameterIndex, value);
        } else {
            statement.setDate(parameterIndex, value, this.calendar);
        }
    }
}

