/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.io.IOException;
import java.math.RoundingMode;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.consumer.ArrayConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BigIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BinaryConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BitConsumer;
import org.apache.arrow.adapter.jdbc.consumer.CompositeJdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DateConsumer;
import org.apache.arrow.adapter.jdbc.consumer.Decimal256Consumer;
import org.apache.arrow.adapter.jdbc.consumer.DecimalConsumer;
import org.apache.arrow.adapter.jdbc.consumer.DoubleConsumer;
import org.apache.arrow.adapter.jdbc.consumer.FloatConsumer;
import org.apache.arrow.adapter.jdbc.consumer.IntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.MapConsumer;
import org.apache.arrow.adapter.jdbc.consumer.NullConsumer;
import org.apache.arrow.adapter.jdbc.consumer.SmallIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimeConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimestampConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TimestampTZConsumer;
import org.apache.arrow.adapter.jdbc.consumer.TinyIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.VarCharConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.ValueVectorUtility;

public class JdbcToArrowUtils {
    private static final int JDBC_ARRAY_VALUE_COLUMN = 2;

    public static Calendar getUtcCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, Calendar calendar) throws SQLException {
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        return JdbcToArrowUtils.jdbcToArrowSchema(rsmd, new JdbcToArrowConfig((BufferAllocator)new RootAllocator(0L), calendar));
    }

    public static Schema jdbcToArrowSchema(ParameterMetaData parameterMetaData, Calendar calendar) throws SQLException {
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        Preconditions.checkNotNull((Object)parameterMetaData);
        ArrayList<Field> parameterFields = new ArrayList<Field>(parameterMetaData.getParameterCount());
        for (int parameterCounter = 1; parameterCounter <= parameterMetaData.getParameterCount(); ++parameterCounter) {
            int jdbcDataType = parameterMetaData.getParameterType(parameterCounter);
            int jdbcIsNullable = parameterMetaData.isNullable(parameterCounter);
            boolean arrowIsNullable = jdbcIsNullable != 0;
            int precision = parameterMetaData.getPrecision(parameterCounter);
            int scale = parameterMetaData.getScale(parameterCounter);
            ArrowType arrowType = JdbcToArrowUtils.getArrowTypeFromJdbcType(new JdbcFieldInfo(jdbcDataType, precision, scale), calendar);
            FieldType fieldType = new FieldType(arrowIsNullable, arrowType, null);
            parameterFields.add(new Field(null, fieldType, null));
        }
        return new Schema(parameterFields);
    }

    public static ArrowType getArrowTypeFromJdbcType(JdbcFieldInfo fieldInfo, Calendar calendar) {
        switch (fieldInfo.getJdbcType()) {
            case -7: 
            case 16: {
                return new ArrowType.Bool();
            }
            case -6: {
                return new ArrowType.Int(8, true);
            }
            case 5: {
                return new ArrowType.Int(16, true);
            }
            case 4: {
                return new ArrowType.Int(32, true);
            }
            case -5: {
                return new ArrowType.Int(64, true);
            }
            case 2: 
            case 3: {
                int precision = fieldInfo.getPrecision();
                int scale = fieldInfo.getScale();
                if (precision > 38) {
                    return new ArrowType.Decimal(precision, scale, 256);
                }
                return new ArrowType.Decimal(precision, scale, 128);
            }
            case 6: 
            case 7: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
            }
            case 8: {
                return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return new ArrowType.Utf8();
            }
            case 91: {
                return new ArrowType.Date(DateUnit.DAY);
            }
            case 92: {
                return new ArrowType.Time(TimeUnit.MILLISECOND, 32);
            }
            case 93: {
                String timezone = calendar != null ? calendar.getTimeZone().getID() : null;
                return new ArrowType.Timestamp(TimeUnit.MILLISECOND, timezone);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new ArrowType.Binary();
            }
            case 2003: {
                return new ArrowType.List();
            }
            case 0: {
                return new ArrowType.Null();
            }
            case 2002: {
                return new ArrowType.Struct();
            }
        }
        throw new UnsupportedOperationException("Unmapped JDBC type: " + fieldInfo.getJdbcType());
    }

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"JDBC ResultSetMetaData object can't be null");
        Preconditions.checkNotNull((Object)config, (Object)"The configuration object must not be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            Map<Object, Object> metadata;
            Map<String, String> columnMetadata;
            String columnName = rsmd.getColumnLabel(i);
            Map<String, String> map = columnMetadata = config.getColumnMetadataByColumnIndex() != null ? config.getColumnMetadataByColumnIndex().get(i) : null;
            if (config.shouldIncludeMetadata()) {
                metadata = new HashMap<String, String>();
                metadata.put("SQL_CATALOG_NAME", rsmd.getCatalogName(i));
                metadata.put("SQL_SCHEMA_NAME", rsmd.getSchemaName(i));
                metadata.put("SQL_TABLE_NAME", rsmd.getTableName(i));
                metadata.put("SQL_COLUMN_NAME", columnName);
                metadata.put("SQL_TYPE", rsmd.getColumnTypeName(i));
                if (columnMetadata != null && !columnMetadata.isEmpty()) {
                    metadata.putAll(columnMetadata);
                }
            } else {
                metadata = columnMetadata != null && !columnMetadata.isEmpty() ? columnMetadata : null;
            }
            JdbcFieldInfo columnFieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForColumn(rsmd, i, config);
            ArrowType arrowType = config.getJdbcToArrowTypeConverter().apply(columnFieldInfo);
            if (arrowType == null) continue;
            FieldType fieldType = new FieldType(JdbcToArrowUtils.isColumnNullable(rsmd, i, columnFieldInfo), arrowType, null, metadata);
            ArrayList<Field> children = null;
            if (arrowType.getTypeID() == ArrowType.List.TYPE_TYPE) {
                JdbcFieldInfo arrayFieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForArraySubType(rsmd, i, config);
                if (arrayFieldInfo == null) {
                    throw new IllegalArgumentException("Configuration does not provide a mapping for array column " + i);
                }
                children = new ArrayList<Field>();
                ArrowType childType = config.getJdbcToArrowTypeConverter().apply(arrayFieldInfo);
                children.add(new Field("child", FieldType.nullable((ArrowType)childType), null));
            } else if (arrowType.getTypeID() == ArrowType.ArrowTypeID.Map) {
                FieldType mapType = new FieldType(false, (ArrowType)ArrowType.Struct.INSTANCE, null, null);
                FieldType keyType = new FieldType(false, (ArrowType)new ArrowType.Utf8(), null, null);
                FieldType valueType = new FieldType(false, (ArrowType)new ArrowType.Utf8(), null, null);
                children = new ArrayList();
                children.add(new Field("child", mapType, Arrays.asList(new Field("key", keyType, null), new Field("value", valueType, null))));
            }
            fields.add(new Field(columnName, fieldType, children));
        }
        return new Schema(fields, config.getSchemaMetadata());
    }

    static JdbcFieldInfo getJdbcFieldInfoForColumn(ResultSetMetaData rsmd, int arrayColumn, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"ResultSet MetaData object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"Configuration must not be null");
        Preconditions.checkArgument((arrayColumn > 0 ? 1 : 0) != 0, (Object)"ResultSetMetaData columns start with 1; column cannot be less than 1");
        Preconditions.checkArgument((arrayColumn <= rsmd.getColumnCount() ? 1 : 0) != 0, (Object)"Column number cannot be more than the number of columns");
        JdbcFieldInfo fieldInfo = config.getExplicitTypeByColumnIndex(arrayColumn);
        if (fieldInfo == null) {
            fieldInfo = config.getExplicitTypeByColumnName(rsmd.getColumnLabel(arrayColumn));
        }
        if (fieldInfo != null) {
            return fieldInfo;
        }
        return new JdbcFieldInfo(rsmd, arrayColumn);
    }

    private static JdbcFieldInfo getJdbcFieldInfoForArraySubType(ResultSetMetaData rsmd, int arrayColumn, JdbcToArrowConfig config) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"ResultSet MetaData object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"Configuration must not be null");
        Preconditions.checkArgument((arrayColumn > 0 ? 1 : 0) != 0, (Object)"ResultSetMetaData columns start with 1; column cannot be less than 1");
        Preconditions.checkArgument((arrayColumn <= rsmd.getColumnCount() ? 1 : 0) != 0, (Object)"Column number cannot be more than the number of columns");
        JdbcFieldInfo fieldInfo = config.getArraySubTypeByColumnIndex(arrayColumn);
        if (fieldInfo == null) {
            fieldInfo = config.getArraySubTypeByColumnName(rsmd.getColumnLabel(arrayColumn));
        }
        return fieldInfo;
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        JdbcToArrowUtils.jdbcToArrowVectors(rs, root, new JdbcToArrowConfig((BufferAllocator)new RootAllocator(0L), calendar));
    }

    static boolean isColumnNullable(ResultSetMetaData resultSetMetadata, int index, JdbcFieldInfo info) throws SQLException {
        int nullableValue = info != null && info.isNullable() != 2 ? info.isNullable() : resultSetMetadata.isNullable(index);
        return nullableValue == 1 || nullableValue == 2;
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, JdbcToArrowConfig config) throws SQLException, IOException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JdbcConsumer[] consumers = new JdbcConsumer[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            FieldVector vector = root.getVector(rsmd.getColumnLabel(i));
            JdbcFieldInfo columnFieldInfo = JdbcToArrowUtils.getJdbcFieldInfoForColumn(rsmd, i, config);
            consumers[i - 1] = JdbcToArrowUtils.getConsumer(vector.getField().getType(), i, JdbcToArrowUtils.isColumnNullable(rsmd, i, columnFieldInfo), vector, config);
        }
        CompositeJdbcConsumer compositeConsumer = null;
        try {
            int readRowCount;
            compositeConsumer = new CompositeJdbcConsumer(consumers);
            if (config.getTargetBatchSize() == -1) {
                while (rs.next()) {
                    ValueVectorUtility.ensureCapacity((VectorSchemaRoot)root, (int)(readRowCount + 1));
                    compositeConsumer.consume(rs);
                    ++readRowCount;
                }
            } else {
                for (readRowCount = 0; readRowCount < config.getTargetBatchSize() && rs.next(); ++readRowCount) {
                    compositeConsumer.consume(rs);
                }
            }
            root.setRowCount(readRowCount);
        }
        catch (Exception e) {
            if (compositeConsumer != null) {
                compositeConsumer.close();
            }
            throw e;
        }
    }

    public static JdbcConsumer getConsumer(ArrowType arrowType, int columnIndex, boolean nullable, FieldVector vector, JdbcToArrowConfig config) {
        Calendar calendar = config.getCalendar();
        switch (arrowType.getTypeID()) {
            case Bool: {
                return BitConsumer.createConsumer((BitVector)vector, columnIndex, nullable);
            }
            case Int: {
                switch (((ArrowType.Int)arrowType).getBitWidth()) {
                    case 8: {
                        return TinyIntConsumer.createConsumer((TinyIntVector)vector, columnIndex, nullable);
                    }
                    case 16: {
                        return SmallIntConsumer.createConsumer((SmallIntVector)vector, columnIndex, nullable);
                    }
                    case 32: {
                        return IntConsumer.createConsumer((IntVector)vector, columnIndex, nullable);
                    }
                    case 64: {
                        return BigIntConsumer.createConsumer((BigIntVector)vector, columnIndex, nullable);
                    }
                }
                return null;
            }
            case Decimal: {
                RoundingMode bigDecimalRoundingMode = config.getBigDecimalRoundingMode();
                if (((ArrowType.Decimal)arrowType).getBitWidth() == 256) {
                    return Decimal256Consumer.createConsumer((Decimal256Vector)vector, columnIndex, nullable, bigDecimalRoundingMode);
                }
                return DecimalConsumer.createConsumer((DecimalVector)vector, columnIndex, nullable, bigDecimalRoundingMode);
            }
            case FloatingPoint: {
                switch (((ArrowType.FloatingPoint)arrowType).getPrecision()) {
                    case SINGLE: {
                        return FloatConsumer.createConsumer((Float4Vector)vector, columnIndex, nullable);
                    }
                    case DOUBLE: {
                        return DoubleConsumer.createConsumer((Float8Vector)vector, columnIndex, nullable);
                    }
                }
                return null;
            }
            case Utf8: 
            case LargeUtf8: {
                return VarCharConsumer.createConsumer((VarCharVector)vector, columnIndex, nullable);
            }
            case Binary: 
            case LargeBinary: {
                return BinaryConsumer.createConsumer((VarBinaryVector)vector, columnIndex, nullable);
            }
            case Date: {
                return DateConsumer.createConsumer((DateDayVector)vector, columnIndex, nullable, calendar);
            }
            case Time: {
                return TimeConsumer.createConsumer((TimeMilliVector)vector, columnIndex, nullable, calendar);
            }
            case Timestamp: {
                if (config.getCalendar() == null) {
                    return TimestampConsumer.createConsumer((TimeStampMilliVector)vector, columnIndex, nullable);
                }
                return TimestampTZConsumer.createConsumer((TimeStampMilliTZVector)vector, columnIndex, nullable, calendar);
            }
            case List: {
                FieldVector childVector = ((ListVector)vector).getDataVector();
                JdbcConsumer delegate = JdbcToArrowUtils.getConsumer(childVector.getField().getType(), 2, childVector.getField().isNullable(), childVector, config);
                return ArrayConsumer.createConsumer((ListVector)vector, delegate, columnIndex, nullable);
            }
            case Map: {
                return MapConsumer.createConsumer((MapVector)vector, columnIndex, nullable);
            }
            case Null: {
                return new NullConsumer((NullVector)vector);
            }
        }
        throw new UnsupportedOperationException("No consumer for Arrow type: " + arrowType);
    }
}

