/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Map;
import java.util.function.Function;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.pojo.ArrowType;

public class JdbcToArrowConfigBuilder {
    private Calendar calendar = null;
    private BufferAllocator allocator = null;
    private boolean includeMetadata = false;
    private boolean reuseVectorSchemaRoot = false;
    private Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex = null;
    private Map<String, JdbcFieldInfo> arraySubTypesByColumnName = null;
    private Map<Integer, JdbcFieldInfo> explicitTypesByColumnIndex = null;
    private Map<String, JdbcFieldInfo> explicitTypesByColumnName = null;
    private Map<String, String> schemaMetadata = null;
    private Map<Integer, Map<String, String>> columnMetadataByColumnIndex = null;
    private int targetBatchSize;
    private Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter;
    private JdbcToArrowConfig.JdbcConsumerFactory jdbcConsumerGetter;
    private RoundingMode bigDecimalRoundingMode = null;

    public JdbcToArrowConfigBuilder() {
    }

    public JdbcToArrowConfigBuilder(BufferAllocator allocator, Calendar calendar) {
        this();
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        this.calendar = calendar;
        this.includeMetadata = false;
        this.reuseVectorSchemaRoot = false;
        this.targetBatchSize = 1024;
    }

    public JdbcToArrowConfigBuilder(BufferAllocator allocator, Calendar calendar, boolean includeMetadata) {
        this(allocator, calendar);
        this.includeMetadata = includeMetadata;
    }

    public JdbcToArrowConfigBuilder setAllocator(BufferAllocator allocator) {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        return this;
    }

    public JdbcToArrowConfigBuilder setCalendar(Calendar calendar) {
        this.calendar = calendar;
        return this;
    }

    public JdbcToArrowConfigBuilder setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
        return this;
    }

    public JdbcToArrowConfigBuilder setArraySubTypeByColumnIndexMap(Map<Integer, JdbcFieldInfo> map) {
        this.arraySubTypesByColumnIndex = map;
        return this;
    }

    public JdbcToArrowConfigBuilder setArraySubTypeByColumnNameMap(Map<String, JdbcFieldInfo> map) {
        this.arraySubTypesByColumnName = map;
        return this;
    }

    public JdbcToArrowConfigBuilder setExplicitTypesByColumnIndex(Map<Integer, JdbcFieldInfo> map) {
        this.explicitTypesByColumnIndex = map;
        return this;
    }

    public JdbcToArrowConfigBuilder setExplicitTypesByColumnName(Map<String, JdbcFieldInfo> map) {
        this.explicitTypesByColumnName = map;
        return this;
    }

    public JdbcToArrowConfigBuilder setTargetBatchSize(int targetBatchSize) {
        this.targetBatchSize = targetBatchSize;
        return this;
    }

    public JdbcToArrowConfigBuilder setJdbcToArrowTypeConverter(Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter) {
        this.jdbcToArrowTypeConverter = jdbcToArrowTypeConverter;
        return this;
    }

    public JdbcToArrowConfigBuilder setJdbcConsumerGetter(JdbcToArrowConfig.JdbcConsumerFactory jdbcConsumerGetter) {
        this.jdbcConsumerGetter = jdbcConsumerGetter;
        return this;
    }

    public JdbcToArrowConfigBuilder setReuseVectorSchemaRoot(boolean reuseVectorSchemaRoot) {
        this.reuseVectorSchemaRoot = reuseVectorSchemaRoot;
        return this;
    }

    public JdbcToArrowConfigBuilder setSchemaMetadata(Map<String, String> schemaMetadata) {
        this.schemaMetadata = schemaMetadata;
        return this;
    }

    public JdbcToArrowConfigBuilder setColumnMetadataByColumnIndex(Map<Integer, Map<String, String>> columnMetadataByColumnIndex) {
        this.columnMetadataByColumnIndex = columnMetadataByColumnIndex;
        return this;
    }

    public JdbcToArrowConfigBuilder setBigDecimalRoundingMode(RoundingMode bigDecimalRoundingMode) {
        this.bigDecimalRoundingMode = bigDecimalRoundingMode;
        return this;
    }

    public JdbcToArrowConfig build() {
        return new JdbcToArrowConfig(this.allocator, this.calendar, this.includeMetadata, this.reuseVectorSchemaRoot, this.arraySubTypesByColumnIndex, this.arraySubTypesByColumnName, this.targetBatchSize, this.jdbcToArrowTypeConverter, this.jdbcConsumerGetter, this.explicitTypesByColumnIndex, this.explicitTypesByColumnName, this.schemaMetadata, this.columnMetadataByColumnIndex, this.bigDecimalRoundingMode);
    }
}

